/*
 * Decompiled with CFR 0.152.
 */
package com.warkiz.widget;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;

class FormatUtils {
    private static final char[][] LEADING_DECIMALS = new char[][]{"0.".toCharArray(), "0.0".toCharArray(), "0.00".toCharArray(), "0.000".toCharArray(), "0.0000".toCharArray(), "0.00000".toCharArray(), "0.000000".toCharArray(), "0.0000000".toCharArray(), "0.00000000".toCharArray(), "0.000000000".toCharArray(), "0.0000000000".toCharArray(), "0.00000000000".toCharArray(), "0.000000000000".toCharArray(), "0.0000000000000".toCharArray(), "0.00000000000000".toCharArray(), "0.000000000000000".toCharArray()};

    FormatUtils() {
    }

    static String fastFormat(double d, int precision) {
        char[] formatChars;
        int posPrecision = Math.abs(precision);
        double roundUpVal = Math.abs(d) * Math.pow(10.0, posPrecision) + 0.5;
        if (roundUpVal > 9.99999999999999E14 || posPrecision > 16) {
            return FormatUtils.bigDecFormat(d, posPrecision);
        }
        long longPart = (long)Math.nextUp(roundUpVal);
        if (longPart < 1L) {
            return "0";
        }
        char[] longPartChars = Long.toString(longPart).toCharArray();
        if (longPartChars.length > posPrecision) {
            int end;
            int decIndex = longPartChars.length - posPrecision;
            for (end = longPartChars.length - 1; end >= decIndex && longPartChars[end] == '0'; --end) {
            }
            if (end >= decIndex) {
                formatChars = new char[end + 2];
                System.arraycopy(longPartChars, 0, formatChars, 0, decIndex);
                formatChars[decIndex] = 46;
                System.arraycopy(longPartChars, decIndex, formatChars, decIndex + 1, end - decIndex + 1);
            } else {
                formatChars = new char[decIndex];
                System.arraycopy(longPartChars, 0, formatChars, 0, decIndex);
            }
        } else {
            int end;
            for (end = longPartChars.length - 1; end >= 0 && longPartChars[end] == '0'; --end) {
            }
            char[] leadings = LEADING_DECIMALS[posPrecision - longPartChars.length];
            formatChars = Arrays.copyOf(leadings, leadings.length + end + 1);
            System.arraycopy(longPartChars, 0, formatChars, leadings.length, end + 1);
        }
        return Math.signum(d) > 0.0 ? new String(formatChars) : "-" + new String(formatChars);
    }

    private static String bigDecFormat(double d, int precision) {
        int end;
        String formatStr = new BigDecimal(Double.toString(d)).setScale(Math.abs(precision), RoundingMode.HALF_UP).toString();
        if (precision == 0) {
            return formatStr;
        }
        for (end = formatStr.length() - 1; end >= 0 && formatStr.charAt(end) == '0'; --end) {
        }
        if ((formatStr = formatStr.substring(0, end + 1)).charAt(formatStr.length() - 1) == '.') {
            formatStr = formatStr.substring(0, formatStr.length() - 1);
        }
        return formatStr;
    }
}

