/*
 * Decompiled with CFR 0.152.
 */
package com.warkiz.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ArrayRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.TextView;
import com.warkiz.widget.BuilderParams;
import com.warkiz.widget.Indicator;
import com.warkiz.widget.IndicatorUtils;
import com.warkiz.widget.R;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class IndicatorSeekBar
extends View {
    private static final int GAP_BETWEEN_SEEK_BAR_AND_BELOW_TEXT = 3;
    private static final int CUSTOM_DRAWABLE_MAX_LIMITED_WIDTH = 30;
    private static final String INSTANCE_STATE_KEY = "isb_instance_state";
    private BuilderParams p;
    private float mTickRadius;
    private Indicator mIndicator;
    private List<Float> mTextLocationList;
    private Rect mCoverRect;
    private int[] mLocation;
    private ArrayList<String> mTextList;
    private Context mContext;
    private Paint mStockPaint;
    private TextPaint mTextPaint;
    private float mTouchX;
    private float mTrackY;
    private float mSeekLength;
    private float mSeekStart;
    private float mSeekEnd;
    private Rect mRect;
    private int mPaddingLeft;
    private int mPaddingRight;
    private int mMeasuredWidth;
    private float mSeekBlockLength;
    private int mPaddingTop;
    private Bitmap mTickDraw;
    private Bitmap mThumbDraw;
    private boolean mDrawAgain;
    private boolean mIsTouching;
    private float mThumbRadius;
    private float mThumbTouchRadius;
    private OnSeekBarChangeListener mListener;
    private float lastProgress;
    private float mFaultTolerance = -1.0f;
    private int mTextHeight;
    private float mThumbTouchHeight;
    private float mCustomDrawableMaxHeight;
    private float mScreenWidth = -1.0f;
    private Builder mBuilder;
    private BuilderParams mRawParams;

    public IndicatorSeekBar(Context context) {
        this(context, null);
    }

    public IndicatorSeekBar(Builder builder) {
        super(builder.getContext(), null, 0);
        this.mContext = builder.getContext();
        this.mBuilder = builder;
        this.p = builder.p;
        this.mRawParams = new BuilderParams(this.mContext).copy(this.p);
        this.initData();
    }

    public IndicatorSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IndicatorSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initAttrs(this.mContext, attrs);
        this.mRawParams = new BuilderParams(this.mContext).copy(this.p);
        this.initData();
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        int indicatorCustomTopContentLayoutId;
        this.p = new BuilderParams(context);
        if (attrs == null) {
            return;
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.IndicatorSeekBar);
        this.p.mSeekBarType = ta.getInt(R.styleable.IndicatorSeekBar_isb_seek_bar_type, this.p.mSeekBarType);
        this.p.mMax = ta.getFloat(R.styleable.IndicatorSeekBar_isb_max, this.p.mMax);
        this.p.mMin = ta.getFloat(R.styleable.IndicatorSeekBar_isb_min, this.p.mMin);
        this.p.mProgress = ta.getFloat(R.styleable.IndicatorSeekBar_isb_progress, this.p.mProgress);
        this.p.mClearPadding = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_clear_default_padding, this.p.mClearPadding);
        this.p.mIsFloatProgress = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_progress_value_float, this.p.mIsFloatProgress);
        this.p.mBackgroundTrackSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_track_background_bar_size, this.p.mBackgroundTrackSize);
        this.p.mProgressTrackSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_track_progress_bar_size, this.p.mProgressTrackSize);
        this.p.mBackgroundTrackColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_track_background_bar_color, this.p.mBackgroundTrackColor);
        this.p.mProgressTrackColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_track_progress_bar_color, this.p.mProgressTrackColor);
        this.p.mTrackRoundedCorners = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_track_rounded_corners, this.p.mTrackRoundedCorners);
        this.p.mThumbColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_thumb_color, this.p.mThumbColor);
        this.p.mThumbSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_thumb_width, this.p.mThumbSize);
        this.p.mThumbProgressStay = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_thumb_progress_stay, this.p.mThumbProgressStay);
        this.p.mThumbDrawable = ta.getDrawable(R.styleable.IndicatorSeekBar_isb_thumb_drawable);
        this.p.mIndicatorType = ta.getInt(R.styleable.IndicatorSeekBar_isb_indicator_type, this.p.mIndicatorType);
        this.p.mIndicatorColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_indicator_color, this.p.mIndicatorColor);
        this.p.mIndicatorTextColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_indicator_text_color, this.p.mIndicatorTextColor);
        this.p.mShowIndicator = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_show_indicator, this.p.mShowIndicator);
        this.p.mIndicatorStay = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_indicator_stay, this.p.mIndicatorStay);
        this.p.mIndicatorTextSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_indicator_text_size, this.p.mIndicatorTextSize);
        int indicatorCustomViewId = ta.getResourceId(R.styleable.IndicatorSeekBar_isb_indicator_custom_layout, 0);
        if (indicatorCustomViewId > 0) {
            this.p.mIndicatorCustomView = View.inflate((Context)this.mContext, (int)indicatorCustomViewId, null);
        }
        if ((indicatorCustomTopContentLayoutId = ta.getResourceId(R.styleable.IndicatorSeekBar_isb_indicator_custom_top_content_layout, 0)) > 0) {
            this.p.mIndicatorCustomTopContentView = View.inflate((Context)this.mContext, (int)indicatorCustomTopContentLayoutId, null);
        }
        this.p.mTickDrawable = ta.getDrawable(R.styleable.IndicatorSeekBar_isb_tick_drawable);
        this.p.mTickNum = ta.getInt(R.styleable.IndicatorSeekBar_isb_tick_num, this.p.mTickNum);
        this.p.mTickColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_tick_color, this.p.mTickColor);
        this.p.mTickType = ta.getInt(R.styleable.IndicatorSeekBar_isb_tick_type, this.p.mTickType);
        this.p.mTickHideBothEnds = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_tick_both_end_hide, this.p.mTickHideBothEnds);
        this.p.mTickOnThumbLeftHide = ta.getBoolean(R.styleable.IndicatorSeekBar_isb_tick_on_thumb_left_hide, this.p.mTickOnThumbLeftHide);
        this.p.mTickSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_tick_size, this.p.mTickSize);
        this.p.mTextArray = ta.getTextArray(R.styleable.IndicatorSeekBar_isb_text_array);
        this.p.mLeftEndText = ta.getString(R.styleable.IndicatorSeekBar_isb_text_left_end);
        this.p.mRightEndText = ta.getString(R.styleable.IndicatorSeekBar_isb_text_right_end);
        this.p.mTextSize = ta.getDimensionPixelSize(R.styleable.IndicatorSeekBar_isb_text_size, this.p.mTextSize);
        this.p.mTextColor = ta.getColor(R.styleable.IndicatorSeekBar_isb_text_color, this.p.mTextColor);
        ta.recycle();
    }

    private void initData() {
        int maxTickWidth;
        if (this.mTextLocationList == null) {
            this.mTextLocationList = new ArrayList<Float>();
        } else {
            this.mTextLocationList.clear();
        }
        if (this.mTextList == null) {
            this.mTextList = new ArrayList();
        } else {
            this.mTextList.clear();
        }
        if (this.p.mMax < this.p.mMin) {
            this.p.mMax = this.p.mMin;
        }
        if (this.p.mProgress < this.p.mMin) {
            this.p.mProgress = this.p.mMin;
        }
        if (this.p.mProgress > this.p.mMax) {
            this.p.mProgress = this.p.mMax;
        }
        if (this.p.mBackgroundTrackSize > this.p.mProgressTrackSize) {
            this.p.mBackgroundTrackSize = this.p.mProgressTrackSize;
        }
        if (this.p.mTickNum < 0) {
            this.p.mTickNum = 0;
        }
        if (this.p.mTickNum > 100) {
            this.p.mTickNum = 100;
        }
        if (this.p.mLeftEndText == null) {
            this.p.mLeftEndText = this.p.mIsFloatProgress ? this.p.mMin + "" : Math.round(this.p.mMin) + "";
        }
        if (this.p.mRightEndText == null) {
            this.p.mRightEndText = this.p.mIsFloatProgress ? this.p.mMax + "" : Math.round(this.p.mMax) + "";
        }
        if (this.p.mTickDrawable != null) {
            this.p.mTickType = 1;
        }
        if (this.p.mThumbDrawable == null) {
            this.mThumbRadius = (float)this.p.mThumbSize / 2.0f;
            this.mThumbTouchRadius = this.mThumbRadius * 1.2f;
            this.mThumbTouchHeight = this.mThumbTouchRadius * 2.0f;
        } else {
            int maxThumbWidth = IndicatorUtils.dp2px(this.mContext, 30.0f);
            this.mThumbRadius = this.p.mThumbSize > maxThumbWidth ? (float)maxThumbWidth / 2.0f : (float)this.p.mThumbSize / 2.0f;
            this.mThumbTouchRadius = this.mThumbRadius;
            this.mThumbTouchHeight = this.mThumbTouchRadius * 2.0f;
        }
        this.mTickRadius = this.p.mTickDrawable == null ? (float)this.p.mTickSize / 2.0f : (this.p.mTickSize > (maxTickWidth = IndicatorUtils.dp2px(this.mContext, 30.0f)) ? (float)maxTickWidth / 2.0f : (float)this.p.mTickSize / 2.0f);
        this.mCustomDrawableMaxHeight = this.mThumbTouchRadius >= this.mTickRadius ? this.mThumbTouchHeight : this.mTickRadius * 2.0f;
        this.initStrokePaint();
        this.initDefaultPadding();
        if (this.noTick()) {
            this.p.mTickNum = this.p.mMax - this.p.mMin > 100.0f ? Math.round(this.p.mMax - this.p.mMin) : 100;
            if (this.p.mIsFloatProgress) {
                this.p.mTickNum *= 10;
            }
        } else {
            int n = this.p.mTickNum = this.p.mTickNum < 2 ? 2 : this.p.mTickNum - 1;
        }
        if (this.needDrawText()) {
            this.initTextPaint();
            this.mTextPaint.getTextBounds("jf1", 0, 3, this.mRect);
            this.mTextHeight = 0;
            this.mTextHeight += this.mRect.height() + IndicatorUtils.dp2px(this.mContext, 6.0f);
        }
        this.lastProgress = this.p.mProgress;
    }

    private void calculateProgressTouchX() {
        float touchX = (this.p.mProgress - this.p.mMin) * this.mSeekLength / (this.p.mMax - this.p.mMin) + (float)this.mPaddingLeft;
        this.calculateTouchX(touchX);
    }

    float getTouchX() {
        this.calculateProgressTouchX();
        return this.mTouchX;
    }

    private boolean noTick() {
        return this.p.mSeekBarType == 0 || this.p.mSeekBarType == 1;
    }

    private void initEndTexts() {
        if (this.mTextList.size() == 0) {
            if (this.p.mLeftEndText != null) {
                this.mTextList.add(this.p.mLeftEndText);
                this.mTextLocationList.add(Float.valueOf(this.mPaddingLeft));
            }
            if (this.p.mRightEndText != null) {
                this.mTextList.add(this.p.mRightEndText);
                this.mTextLocationList.add(Float.valueOf(this.mMeasuredWidth - this.mPaddingRight));
            }
        } else if (this.mTextList.size() == 1) {
            if (this.p.mLeftEndText != null) {
                this.mTextList.set(0, this.p.mLeftEndText);
            }
            if (this.p.mRightEndText != null) {
                this.mTextList.add(this.p.mRightEndText);
                this.mTextLocationList.add(Float.valueOf(this.mMeasuredWidth - this.mPaddingRight));
            }
        } else {
            if (this.p.mLeftEndText != null) {
                this.mTextList.set(0, this.p.mLeftEndText);
            }
            if (this.p.mLeftEndText != null) {
                this.mTextList.set(this.mTextList.size() - 1, this.p.mRightEndText);
            }
        }
    }

    private void initDefaultPadding() {
        if (!this.p.mClearPadding) {
            int normalPadding = IndicatorUtils.dp2px(this.mContext, 16.0f);
            if (this.getPaddingLeft() == 0) {
                this.setPadding(normalPadding, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
            }
            if (this.getPaddingRight() == 0) {
                this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), normalPadding, this.getPaddingBottom());
            }
        }
    }

    private void initStrokePaint() {
        if (this.mStockPaint == null) {
            this.mStockPaint = new Paint();
        }
        if (this.p.mTrackRoundedCorners) {
            this.mStockPaint.setStrokeCap(Paint.Cap.ROUND);
        }
        this.mStockPaint.setAntiAlias(true);
        if (this.p.mBackgroundTrackSize > this.p.mProgressTrackSize) {
            this.p.mProgressTrackSize = this.p.mBackgroundTrackSize;
        }
    }

    private void initTextPaint() {
        if (this.mTextPaint == null) {
            this.mTextPaint = new TextPaint();
        }
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setTextSize((float)this.p.mTextSize);
        this.mTextPaint.setColor(this.p.mTextColor);
        if (this.mRect == null) {
            this.mRect = new Rect();
        }
    }

    private boolean needDrawText() {
        return this.p.mSeekBarType == 1 || this.p.mSeekBarType == 3 || this.p.mSeekBarType == 4 || this.p.mThumbProgressStay;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = Math.round(this.mCustomDrawableMaxHeight + 0.5f + (float)this.getPaddingTop() + (float)this.getPaddingBottom());
        this.setMeasuredDimension(IndicatorSeekBar.resolveSize((int)IndicatorUtils.dp2px(this.mContext, 170.0f), (int)widthMeasureSpec), height + this.mTextHeight);
        this.initSeekBarInfo();
        if (this.p.mShowIndicator && this.mIndicator == null) {
            this.mIndicator = new Indicator(this.mContext, this, this.p);
        }
    }

    protected void onDraw(Canvas canvas) {
        this.mStockPaint.setColor(this.p.mProgressTrackColor);
        if (!this.mDrawAgain) {
            float touchX = (this.p.mProgress - this.p.mMin) * this.mSeekLength / (this.p.mMax - this.p.mMin) + (float)this.mPaddingLeft;
            this.calculateTouchX(touchX);
            this.mDrawAgain = true;
        }
        float thumbX = this.getThumbX();
        this.mStockPaint.setStrokeWidth((float)this.p.mProgressTrackSize);
        canvas.drawLine(this.mSeekStart, this.mTrackY, thumbX, this.mTrackY, this.mStockPaint);
        this.mStockPaint.setStrokeWidth((float)this.p.mBackgroundTrackSize);
        this.mStockPaint.setColor(this.p.mBackgroundTrackColor);
        canvas.drawLine(thumbX, this.mTrackY, this.mSeekEnd, this.mTrackY, this.mStockPaint);
        this.drawTicks(canvas, thumbX);
        this.drawText(canvas);
        this.drawThumbText(canvas, thumbX);
        this.drawThumb(canvas, thumbX);
        if (this.p.mShowIndicator && this.p.mIndicatorStay && !this.mIndicator.isShowing() && !this.isCover()) {
            this.calculateProgressTouchX();
            this.mIndicator.showIndicator(this.mTouchX);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (!this.p.mShowIndicator) {
            return;
        }
        if ((8 == visibility || 4 == visibility) && this.mIndicator != null) {
            this.mIndicator.forceHideIndicator();
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 4 || visibility == 8) {
            if (this.mIndicator != null) {
                this.mIndicator.forceHideIndicator();
            }
            return;
        }
        if (!this.p.mShowIndicator || !this.p.mIndicatorStay) {
            return;
        }
        if (visibility == 0) {
            this.getViewTreeObserver().addOnScrollChangedListener(new ViewTreeObserver.OnScrollChangedListener(){

                public void onScrollChanged() {
                    if (IndicatorSeekBar.this.isCover()) {
                        IndicatorSeekBar.this.mIndicator.forceHideIndicator();
                    } else if (IndicatorSeekBar.this.getVisibility() == 0) {
                        IndicatorSeekBar.this.calculateProgressTouchX();
                        IndicatorSeekBar.this.mIndicator.showIndicator(IndicatorSeekBar.this.mTouchX);
                    }
                }
            });
        }
    }

    boolean isCover() {
        if (this.mCoverRect == null) {
            this.mCoverRect = new Rect();
        }
        if (this.getGlobalVisibleRect(this.mCoverRect) && this.mCoverRect.width() >= this.getMeasuredWidth() && this.mCoverRect.height() >= this.getMeasuredHeight()) {
            if (this.mScreenWidth < 0.0f) {
                this.initScreenWidth();
            }
            if (this.mScreenWidth > 0.0f) {
                int left = this.mCoverRect.left;
                int top = this.mCoverRect.top;
                if (this.mLocation == null) {
                    this.mLocation = new int[2];
                }
                this.getLocationInWindow(this.mLocation);
                if (left == this.mLocation[0] && top == this.mLocation[1]) {
                    return false;
                }
            }
        }
        return true;
    }

    private void initScreenWidth() {
        DisplayMetrics metric = new DisplayMetrics();
        WindowManager systemService = (WindowManager)this.mContext.getSystemService("window");
        if (systemService != null) {
            systemService.getDefaultDisplay().getMetrics(metric);
            this.mScreenWidth = metric.widthPixels;
        }
    }

    private void drawThumb(Canvas canvas, float thumbX) {
        this.mStockPaint.setColor(this.p.mThumbColor);
        if (this.p.mThumbDrawable != null) {
            if (this.mThumbDraw == null) {
                this.mThumbDraw = this.getBitmapDraw(this.p.mThumbDrawable, true);
            }
            canvas.drawBitmap(this.mThumbDraw, thumbX - (float)this.mThumbDraw.getWidth() / 2.0f, this.mTrackY - (float)this.mThumbDraw.getHeight() / 2.0f, this.mStockPaint);
        } else {
            canvas.drawCircle(thumbX + (float)this.p.mBackgroundTrackSize / 2.0f, this.mTrackY, this.mIsTouching ? this.mThumbTouchRadius : this.mThumbRadius, this.mStockPaint);
        }
    }

    private void drawThumbText(Canvas canvas, float thumbX) {
        if (this.p.mSeekBarType != 0 && this.p.mSeekBarType != 2) {
            return;
        }
        if (this.p.mThumbProgressStay) {
            canvas.drawText(this.getProgressString(this.p.mProgress), thumbX + (float)this.p.mBackgroundTrackSize / 2.0f, (float)this.mPaddingTop + this.mThumbTouchHeight + (float)this.mRect.height() + (float)IndicatorUtils.dp2px(this.mContext, 2.0f), (Paint)this.mTextPaint);
        }
    }

    private void initSeekBarInfo() {
        this.mMeasuredWidth = this.getMeasuredWidth();
        this.mPaddingLeft = this.getPaddingLeft();
        this.mPaddingRight = this.getPaddingRight();
        this.mPaddingTop = this.getPaddingTop();
        this.mSeekLength = this.mMeasuredWidth - this.mPaddingLeft - this.mPaddingRight;
        this.mSeekBlockLength = this.mSeekLength / (float)this.p.mTickNum;
        this.mTrackY = this.mThumbTouchRadius >= this.mTickRadius ? (float)this.mPaddingTop + this.mThumbTouchRadius : (float)this.mPaddingTop + this.mTickRadius;
        this.mSeekStart = this.p.mTrackRoundedCorners ? (float)this.mPaddingLeft + (float)this.p.mBackgroundTrackSize / 2.0f : (float)this.mPaddingLeft;
        this.mSeekEnd = (float)(this.mMeasuredWidth - this.mPaddingRight) - (float)this.p.mBackgroundTrackSize / 2.0f;
        this.initLocationListData();
    }

    private void drawTicks(Canvas canvas, float thumbX) {
        if (this.p.mSeekBarType == 0 || this.p.mSeekBarType == 1 || this.p.mTickType == 0) {
            return;
        }
        if (this.mTextLocationList.size() == 0) {
            return;
        }
        this.mStockPaint.setColor(this.p.mTickColor);
        for (int i = 0; i < this.mTextLocationList.size(); ++i) {
            float locationX = this.mTextLocationList.get(i).floatValue();
            if (this.getThumbPosOnTick() == i || this.p.mTickOnThumbLeftHide && thumbX >= locationX || this.p.mTickHideBothEnds && (i == 0 || i == this.mTextLocationList.size() - 1)) continue;
            int rectWidth = IndicatorUtils.dp2px(this.mContext, 1.0f);
            if (this.p.mTickDrawable != null) {
                if (this.mTickDraw == null) {
                    this.mTickDraw = this.getBitmapDraw(this.p.mTickDrawable, false);
                }
                if (this.p.mTickType == 1) {
                    canvas.drawBitmap(this.mTickDraw, locationX - (float)this.mTickDraw.getWidth() / 2.0f + (float)rectWidth, this.mTrackY - (float)this.mTickDraw.getHeight() / 2.0f, this.mStockPaint);
                    continue;
                }
                canvas.drawBitmap(this.mTickDraw, locationX - (float)this.mTickDraw.getWidth() / 2.0f, this.mTrackY - (float)this.mTickDraw.getHeight() / 2.0f, this.mStockPaint);
                continue;
            }
            if (this.p.mTickType == 2) {
                canvas.drawCircle(locationX, this.mTrackY, this.mTickRadius, this.mStockPaint);
                continue;
            }
            if (this.p.mTickType != 1) continue;
            float rectTickHeightRange = thumbX >= locationX ? (float)this.p.mProgressTrackSize : (float)this.p.mBackgroundTrackSize;
            canvas.drawRect(locationX - (float)rectWidth, this.mTrackY - rectTickHeightRange / 2.0f - 0.5f, locationX + (float)rectWidth, this.mTrackY + rectTickHeightRange / 2.0f + 0.5f, this.mStockPaint);
        }
    }

    private Bitmap getBitmapDraw(Drawable drawable2, boolean isThumb) {
        int height;
        int width;
        if (drawable2 == null) {
            return null;
        }
        int maxRange = IndicatorUtils.dp2px(this.mContext, 30.0f);
        int intrinsicWidth = drawable2.getIntrinsicWidth();
        if (intrinsicWidth > maxRange) {
            width = isThumb ? this.p.mThumbSize : this.p.mTickSize;
            height = this.getHeightByRatio(drawable2, width);
            if (width > maxRange) {
                width = maxRange;
                height = this.getHeightByRatio(drawable2, width);
            }
        } else {
            width = drawable2.getIntrinsicWidth();
            height = drawable2.getIntrinsicHeight();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private int getHeightByRatio(Drawable drawable2, int width) {
        int intrinsicWidth = drawable2.getIntrinsicWidth();
        int intrinsicHeight = drawable2.getIntrinsicHeight();
        return Math.round(1.0f * (float)width * (float)intrinsicHeight / (float)intrinsicWidth);
    }

    private void drawText(Canvas canvas) {
        if (this.p.mSeekBarType == 0 || this.p.mSeekBarType == 2) {
            return;
        }
        if (this.mTextList.size() == 0) {
            return;
        }
        this.mStockPaint.setColor(this.p.mTickColor);
        String allText = this.getAllText();
        this.mTextPaint.getTextBounds(allText, 0, allText.length(), this.mRect);
        int textHeight = Math.round((float)this.mRect.height() - this.mTextPaint.descent());
        int gap = IndicatorUtils.dp2px(this.mContext, 3.0f);
        for (int i = 0; i < this.mTextList.size(); ++i) {
            String text = this.getStringText(i);
            this.mTextPaint.getTextBounds(text, 0, text.length(), this.mRect);
            if (i == 0) {
                canvas.drawText(text, this.mTextLocationList.get(i).floatValue() + (float)this.mRect.width() / 2.0f, (float)this.mPaddingTop + this.mCustomDrawableMaxHeight + (float)textHeight + (float)gap, (Paint)this.mTextPaint);
                continue;
            }
            if (i == this.mTextList.size() - 1) {
                canvas.drawText(text, this.mTextLocationList.get(i).floatValue() - (float)this.mRect.width() / 2.0f, (float)this.mPaddingTop + this.mCustomDrawableMaxHeight + (float)textHeight + (float)gap, (Paint)this.mTextPaint);
                continue;
            }
            if (this.p.mSeekBarType == 1 || this.p.mSeekBarType == 4) continue;
            canvas.drawText(text, this.mTextLocationList.get(i).floatValue(), (float)this.mPaddingTop + this.mCustomDrawableMaxHeight + (float)textHeight + (float)gap, (Paint)this.mTextPaint);
        }
    }

    @NonNull
    private String getStringText(int i) {
        String text = this.p.mTextArray != null ? (i < this.p.mTextArray.length ? this.p.mTextArray[i] + "" : " ") : this.mTextList.get(i) + "";
        return text;
    }

    @NonNull
    private String getAllText() {
        StringBuilder sb = new StringBuilder();
        sb.append("j");
        if (this.p.mTextArray != null) {
            for (CharSequence text : this.p.mTextArray) {
                sb.append(text);
            }
        }
        return sb.toString();
    }

    private void initLocationListData() {
        if (this.p.mSeekBarType == 0) {
            return;
        }
        if (this.p.mSeekBarType == 1) {
            this.initEndTexts();
            return;
        }
        if (this.p.mTickNum > 1) {
            this.mTextLocationList.clear();
            this.mTextList.clear();
            for (int i = 0; i < this.p.mTickNum + 1; ++i) {
                float tickX = this.mSeekBlockLength * (float)i;
                this.mTextLocationList.add(Float.valueOf(tickX + (float)this.mPaddingLeft));
                float tickProgress = this.p.mMin + (this.p.mMax - this.p.mMin) * tickX / this.mSeekLength;
                this.mTextList.add(this.getProgressString(tickProgress));
            }
            this.initEndTexts();
            this.initDefaultTextArray(this.mTextList);
        }
    }

    private void initDefaultTextArray(ArrayList<String> mTextList) {
        if (this.p.mTextArray != null) {
            return;
        }
        CharSequence[] charSequence = new CharSequence[mTextList.size()];
        for (int i = 0; i < mTextList.size(); ++i) {
            charSequence[i] = mTextList.get(i);
        }
        this.p.mTextArray = charSequence;
    }

    private float getThumbX() {
        float mThumbXCache = this.mTouchX - (float)this.p.mBackgroundTrackSize / 2.0f;
        float mThumbX = mThumbXCache <= this.mSeekStart ? (mThumbXCache <= (float)this.mPaddingLeft ? (float)this.getPaddingLeft() - (float)this.p.mBackgroundTrackSize / 2.0f : mThumbXCache + (float)this.p.mBackgroundTrackSize / 2.0f) : (mThumbXCache >= (float)(this.mMeasuredWidth - this.mPaddingRight) - (float)this.p.mBackgroundTrackSize / 2.0f ? (float)(this.mMeasuredWidth - this.mPaddingRight) - (float)this.p.mBackgroundTrackSize / 2.0f : mThumbXCache);
        return mThumbX;
    }

    public int getThumbPosOnTick() {
        if (this.p.mSeekBarType > 1) {
            return Math.round((this.mTouchX - (float)this.mPaddingLeft) / this.mSeekBlockLength);
        }
        return -1;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.performClick();
                if (!this.isTouchSeekBar(event)) break;
                if (this.mListener != null) {
                    this.mListener.onStartTrackingTouch(this, this.getThumbPosOnTick());
                }
                this.refreshSeekBar(event, true);
                return true;
            }
            case 2: {
                this.refreshSeekBar(event, false);
                break;
            }
            case 1: 
            case 3: {
                if (this.mListener != null) {
                    this.mListener.onStopTrackingTouch(this);
                }
                this.mIsTouching = false;
                this.invalidate();
                if (!this.p.mShowIndicator) break;
                this.mIndicator.hideIndicator();
            }
        }
        return super.onTouchEvent(event);
    }

    public boolean performClick() {
        return super.performClick();
    }

    private void setListener(boolean formUserTouch) {
        if (this.mListener != null) {
            this.mListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), formUserTouch);
            if (this.p.mSeekBarType > 1) {
                int thumbPosOnTick = this.getThumbPosOnTick();
                if (this.p.mTextArray != null && thumbPosOnTick < this.p.mTextArray.length) {
                    this.mListener.onSectionChanged(this, thumbPosOnTick, String.valueOf(this.p.mTextArray[thumbPosOnTick]), formUserTouch);
                } else {
                    this.mListener.onSectionChanged(this, thumbPosOnTick, "", formUserTouch);
                }
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: 
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return super.dispatchTouchEvent(event);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE_KEY, super.onSaveInstanceState());
        bundle.putFloat("isb_progress", this.p.mProgress);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.p.mProgress = bundle.getFloat("isb_progress");
            super.onRestoreInstanceState(bundle.getParcelable(INSTANCE_STATE_KEY));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mIndicator != null) {
            this.mIndicator.forceHideIndicator();
        }
    }

    private void refreshSeekBar(MotionEvent event, boolean isDownTouch) {
        this.calculateTouchX(this.adjustTouchX(event));
        this.calculateProgress();
        this.mIsTouching = true;
        if (isDownTouch) {
            if (this.lastProgress != this.p.mProgress) {
                this.setListener(true);
            }
            this.invalidate();
            if (this.p.mShowIndicator) {
                if (this.mIndicator.isShowing()) {
                    this.mIndicator.update(this.mTouchX);
                } else {
                    this.mIndicator.showIndicator(this.mTouchX);
                }
            }
        } else if (this.lastProgress != this.p.mProgress) {
            this.setListener(true);
            this.invalidate();
            if (this.p.mShowIndicator) {
                this.mIndicator.update(this.mTouchX);
            }
        }
    }

    private float adjustTouchX(MotionEvent event) {
        float mTouchXCache = event.getX() < (float)this.mPaddingLeft ? (float)this.mPaddingLeft : (event.getX() > (float)(this.mMeasuredWidth - this.mPaddingRight) ? (float)(this.mMeasuredWidth - this.mPaddingRight) : event.getX());
        return mTouchXCache;
    }

    private void calculateProgress() {
        this.lastProgress = this.p.mProgress;
        this.p.mProgress = this.p.mMin + (this.p.mMax - this.p.mMin) * (this.mTouchX - (float)this.mPaddingLeft) / this.mSeekLength;
    }

    private void calculateTouchX(float touchX) {
        int touchBlockSize = Math.round((touchX - (float)this.mPaddingLeft) / this.mSeekBlockLength);
        this.mTouchX = this.mSeekBlockLength * (float)touchBlockSize + (float)this.mPaddingLeft;
    }

    private boolean isTouchSeekBar(MotionEvent event) {
        float mX = event.getX();
        float mY = event.getY();
        if (this.mFaultTolerance == -1.0f) {
            this.mFaultTolerance = IndicatorUtils.dp2px(this.mContext, 5.0f);
        }
        boolean inWidthRange = mX >= (float)this.mPaddingLeft - 2.0f * this.mFaultTolerance && mX <= (float)(this.mMeasuredWidth - this.mPaddingRight) + 2.0f * this.mFaultTolerance;
        boolean inHeightRange = mY >= this.mTrackY - this.mThumbTouchRadius - this.mFaultTolerance && mY <= this.mTrackY + this.mThumbTouchRadius + this.mFaultTolerance;
        return inWidthRange && inHeightRange;
    }

    private float getProgressFloat(int newScale) {
        BigDecimal bigDecimal = BigDecimal.valueOf(this.p.mProgress);
        return bigDecimal.setScale(newScale, 4).floatValue();
    }

    private float getProgressFloat(int newScale, float progress) {
        BigDecimal bigDecimal = BigDecimal.valueOf(progress);
        return bigDecimal.setScale(newScale, 4).floatValue();
    }

    private int getProgress(float progress) {
        return Math.round(progress);
    }

    private String getProgressString(float progress) {
        String progressString = this.p.mIsFloatProgress ? String.valueOf(this.getProgressFloat(1, progress)) : String.valueOf(this.getProgress(progress));
        return progressString;
    }

    String getProgressString() {
        if (this.p.mSeekBarType == 3) {
            int thumbPosOnTick = this.getThumbPosOnTick();
            if (thumbPosOnTick >= this.p.mTextArray.length) {
                return "";
            }
            return String.valueOf(this.p.mTextArray[thumbPosOnTick]);
        }
        return this.getProgressString(this.p.mProgress);
    }

    public int getProgress() {
        return Math.round(this.p.mProgress);
    }

    public void setMax(float max) {
        if (max < this.mRawParams.mMin) {
            max = this.mRawParams.mMin;
        }
        this.mRawParams.mMax = max;
        this.p.copy(this.mRawParams);
        this.initData();
        this.requestLayout();
    }

    public void setMin(float min) {
        if (min > this.mRawParams.mMax) {
            min = this.mRawParams.mMax;
        }
        this.mRawParams.mMin = min;
        this.p.copy(this.mRawParams);
        this.initData();
        this.requestLayout();
    }

    public void setProgress(float progress) {
        this.p.mProgress = progress < this.p.mMin ? this.p.mMin : (progress > this.p.mMax ? this.p.mMax : progress);
        this.setListener(false);
        float touchX = (this.p.mProgress - this.p.mMin) * this.mSeekLength / (this.p.mMax - this.p.mMin) + (float)this.mPaddingLeft;
        this.calculateTouchX(touchX);
        this.postInvalidate();
    }

    public Builder getBuilder() {
        if (this.mBuilder == null) {
            this.mBuilder = new Builder(this.mContext);
        }
        return this.mBuilder.setParams(this.mRawParams).setSeekBar(this);
    }

    public float getProgressFloat() {
        return this.getProgressFloat(1);
    }

    public float getMax() {
        return this.p.mMax;
    }

    public float getMin() {
        return this.p.mMin;
    }

    public Indicator getIndicator() {
        return this.mIndicator;
    }

    public void setCustomIndicator(@NonNull View customIndicatorView) {
        this.mIndicator.setCustomIndicator(customIndicatorView);
    }

    public void setCustomIndicator(@LayoutRes int customIndicatorViewId) {
        this.mIndicator.setCustomIndicator(View.inflate((Context)this.mContext, (int)customIndicatorViewId, null));
    }

    public void setCustomIndicator(@NonNull View customIndicatorView, @IdRes int progressTextViewId) {
        View tv = customIndicatorView.findViewById(progressTextViewId);
        if (tv == null) {
            throw new IllegalArgumentException(" can not find the textView in topContentView by progressTextViewId. ");
        }
        if (!(tv instanceof TextView)) {
            throw new ClassCastException(" the view identified by progressTextViewId can not be cast to TextView. ");
        }
        this.mIndicator.setProgressTextView((TextView)tv);
        this.mIndicator.setCustomIndicator(customIndicatorView);
    }

    private void apply(BuilderParams p) {
        if (p == null) {
            throw new NullPointerException(" BuilderParams can not be a null value. ");
        }
        this.mRawParams.copy(p);
        this.p.copy(p);
        this.initData();
        this.requestLayout();
        if (this.mIndicator != null) {
            this.mIndicator.initIndicator();
        }
    }

    public CharSequence[] getTextArray() {
        return this.p.mTextArray;
    }

    public void setTextArray(@NonNull CharSequence[] textArray) {
        this.p.mTextArray = textArray;
        this.invalidate();
    }

    public void setTextArray(@ArrayRes int textArray) {
        this.p.mTextArray = this.mContext.getResources().getStringArray(textArray);
        this.invalidate();
    }

    public void setOnSeekChangeListener(@NonNull OnSeekBarChangeListener listener) {
        this.mListener = listener;
    }

    public static class Builder {
        BuilderParams p;
        IndicatorSeekBar indicatorSeekBar;

        public Builder(Context context) {
            this.p = new BuilderParams(context);
        }

        public IndicatorSeekBar build() {
            return new IndicatorSeekBar(this);
        }

        public IndicatorSeekBar apply() {
            this.indicatorSeekBar.apply(this.p);
            return this.indicatorSeekBar;
        }

        public Builder setProgress(float progress) {
            this.p.mProgress = progress;
            return this;
        }

        public Builder setMax(float max) {
            this.p.mMax = max;
            return this;
        }

        public Builder setMin(float min) {
            this.p.mMin = min;
            return this;
        }

        public Context getContext() {
            return this.p.mContext;
        }

        public Builder clearPadding(boolean clearPadding) {
            this.p.mClearPadding = clearPadding;
            return this;
        }

        public Builder showIndicator(boolean showIndicator) {
            this.p.mShowIndicator = showIndicator;
            return this;
        }

        public Builder setBackgroundTrackSize(int backgroundTrackSize) {
            this.p.mBackgroundTrackSize = IndicatorUtils.dp2px(this.p.mContext, backgroundTrackSize);
            return this;
        }

        public Builder setTextSize(int textSize) {
            this.p.mTextSize = IndicatorUtils.sp2px(this.p.mContext, textSize);
            return this;
        }

        public Builder setBackgroundTrackColor(@ColorInt int backgroundTrackColor) {
            this.p.mBackgroundTrackColor = backgroundTrackColor;
            return this;
        }

        public Builder setProgressTrackColor(@ColorInt int progressTrackColor) {
            this.p.mProgressTrackColor = progressTrackColor;
            return this;
        }

        public Builder setThumbColor(@ColorInt int thumbColor) {
            this.p.mThumbColor = thumbColor;
            return this;
        }

        public Builder setTickNum(int tickNum) {
            this.p.mTickNum = tickNum;
            return this;
        }

        public Builder setTickSize(int tickSize) {
            this.p.mTickSize = IndicatorUtils.dp2px(this.p.mContext, tickSize);
            return this;
        }

        public Builder setTickType(int tickType) {
            this.p.mTickType = tickType;
            return this;
        }

        public Builder setTickColor(@ColorInt int tickColor) {
            this.p.mTickColor = tickColor;
            return this;
        }

        public Builder setSeekBarType(int seekBarType) {
            this.p.mSeekBarType = seekBarType;
            return this;
        }

        public Builder hideBothEndsTicks(boolean tickHideBothEnds) {
            this.p.mTickHideBothEnds = tickHideBothEnds;
            return this;
        }

        public Builder hideTickOnThumbLeft(boolean tickOnThumbLeftHide) {
            this.p.mTickOnThumbLeftHide = tickOnThumbLeftHide;
            return this;
        }

        public Builder isRoundedTrackCorner(boolean trackCornersIsRounded) {
            this.p.mTrackRoundedCorners = trackCornersIsRounded;
            return this;
        }

        public Builder setProgressTrackSize(int progressTrackSize) {
            this.p.mProgressTrackSize = IndicatorUtils.dp2px(this.p.mContext, progressTrackSize);
            return this;
        }

        public Builder setTextArray(CharSequence[] textArray) {
            this.p.mTextArray = textArray;
            return this;
        }

        public Builder setTextArray(@ArrayRes int textArray) {
            this.p.mTextArray = this.p.mContext.getResources().getStringArray(textArray);
            return this;
        }

        public Builder setThumbWidth(int thumbWidth) {
            this.p.mThumbSize = IndicatorUtils.dp2px(this.p.mContext, thumbWidth);
            return this;
        }

        public Builder setIndicatorColor(@ColorInt int indicatorColor) {
            this.p.mIndicatorColor = indicatorColor;
            return this;
        }

        public Builder setIndicatorCustomLayout(@LayoutRes int mIndicatorCustomLayout) {
            this.p.mIndicatorType = 3;
            this.p.mIndicatorCustomView = View.inflate((Context)this.p.mContext, (int)mIndicatorCustomLayout, null);
            return this;
        }

        public Builder setIndicatorCustomView(@NonNull View indicatorCustomView) {
            this.p.mIndicatorType = 3;
            this.p.mIndicatorCustomView = indicatorCustomView;
            return this;
        }

        public Builder setIndicatorCustomTopContentLayout(@LayoutRes int mIndicatorCustomTopContentLayout) {
            this.p.mIndicatorCustomTopContentView = View.inflate((Context)this.p.mContext, (int)mIndicatorCustomTopContentLayout, null);
            return this;
        }

        public Builder setIndicatorCustomTopContentView(@NonNull View topContentView) {
            this.p.mIndicatorCustomTopContentView = topContentView;
            return this;
        }

        public Builder setIndicatorType(int indicatorType) {
            this.p.mIndicatorType = indicatorType;
            return this;
        }

        public Builder thumbProgressStay(boolean thumbProgressStay) {
            this.p.mThumbProgressStay = thumbProgressStay;
            return this;
        }

        public Builder isFloatProgress(boolean floatProgress) {
            this.p.mIsFloatProgress = floatProgress;
            return this;
        }

        public Builder setLeftEndText(String leftEndText) {
            this.p.mLeftEndText = leftEndText;
            return this;
        }

        public Builder setRightEndText(String rightEndText) {
            this.p.mRightEndText = rightEndText;
            return this;
        }

        public Builder setTickDrawableId(@DrawableRes int tickDrawableId) {
            this.p.mTickDrawable = this.p.mContext.getResources().getDrawable(tickDrawableId);
            return this;
        }

        public Builder setTickDrawable(@NonNull Drawable tickDrawable) {
            this.p.mTickDrawable = tickDrawable;
            return this;
        }

        public Builder setThumbDrawable(@DrawableRes int thumbDrawableId) {
            this.p.mThumbDrawable = this.p.mContext.getResources().getDrawable(thumbDrawableId);
            return this;
        }

        public Builder setThumbDrawable(Drawable thumbDrawable) {
            this.p.mThumbDrawable = thumbDrawable;
            return this;
        }

        public Builder setTextColor(@ColorInt int textColor) {
            this.p.mTextColor = textColor;
            return this;
        }

        public Builder setIndicatorTextColor(@ColorInt int indicatorTextColor) {
            this.p.mIndicatorTextColor = indicatorTextColor;
            return this;
        }

        public Builder setIndicatorTextSize(int indicatorTextSize) {
            this.p.mIndicatorTextSize = IndicatorUtils.sp2px(this.p.mContext, indicatorTextSize);
            return this;
        }

        public Builder setIndicatorStay(boolean stay) {
            this.p.mIndicatorStay = stay;
            return this;
        }

        Builder setParams(BuilderParams p) {
            this.p = p;
            return this;
        }

        Builder setSeekBar(IndicatorSeekBar indicatorSeekBar) {
            this.indicatorSeekBar = indicatorSeekBar;
            return this;
        }
    }

    public static interface OnSeekBarChangeListener {
        public void onProgressChanged(IndicatorSeekBar var1, int var2, float var3, boolean var4);

        public void onSectionChanged(IndicatorSeekBar var1, int var2, String var3, boolean var4);

        public void onStartTrackingTouch(IndicatorSeekBar var1, int var2);

        public void onStopTrackingTouch(IndicatorSeekBar var1);
    }
}

