/*
 * Decompiled with CFR 0.152.
 */
package me.wcy.htmltext;

import android.content.Context;
import android.graphics.Color;
import android.text.Editable;
import android.text.Html;
import android.text.Layout;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BulletSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.TypefaceSpan;
import android.widget.TextView;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Stack;
import me.wcy.htmltext.span.NumberSpan;
import org.xml.sax.XMLReader;

class HtmlTagHandler
implements Html.TagHandler {
    private static final String UNORDERED_LIST = "HTML_TEXT_TAG_UL";
    private static final String ORDERED_LIST = "HTML_TEXT_TAG_OL";
    private static final String LIST_ITEM = "HTML_TEXT_TAG_LI";
    private static final String FONT = "HTML_TEXT_TAG_FONT";
    private static final String DIV = "HTML_TEXT_TAG_DIV";
    private Context mContext;
    private TextPaint mTextPaint;
    private Stack<String> lists = new Stack();
    private Stack<Integer> olNextIndex = new Stack();
    private static final int indent = 10;
    private static final int listItemIndent = 20;
    private static final BulletSpan bullet = new BulletSpan(10);

    HtmlTagHandler() {
    }

    void setTextView(TextView textView) {
        this.mContext = textView.getContext().getApplicationContext();
        this.mTextPaint = textView.getPaint();
    }

    String overrideTags(String html) {
        if (html == null) {
            return null;
        }
        html = "<html>" + html + "</html>";
        html = html.replace("<ul", "<HTML_TEXT_TAG_UL");
        html = html.replace("</ul>", "</HTML_TEXT_TAG_UL>");
        html = html.replace("<ol", "<HTML_TEXT_TAG_OL");
        html = html.replace("</ol>", "</HTML_TEXT_TAG_OL>");
        html = html.replace("<li", "<HTML_TEXT_TAG_LI");
        html = html.replace("</li>", "</HTML_TEXT_TAG_LI>");
        html = html.replace("<font", "<HTML_TEXT_TAG_FONT");
        html = html.replace("</font>", "</HTML_TEXT_TAG_FONT>");
        html = html.replace("<div", "<HTML_TEXT_TAG_DIV");
        html = html.replace("</div>", "</HTML_TEXT_TAG_DIV>");
        return html;
    }

    public void handleTag(boolean opening, String tag, Editable output, XMLReader xmlReader) {
        if (opening) {
            if (tag.equalsIgnoreCase(UNORDERED_LIST)) {
                this.lists.push(tag);
            } else if (tag.equalsIgnoreCase(ORDERED_LIST)) {
                this.lists.push(tag);
                this.olNextIndex.push(1);
            } else if (tag.equalsIgnoreCase(LIST_ITEM)) {
                if (output.length() > 0 && output.charAt(output.length() - 1) != '\n') {
                    output.append((CharSequence)"\n");
                }
                if (!this.lists.isEmpty()) {
                    String parentList = this.lists.peek();
                    if (parentList.equalsIgnoreCase(ORDERED_LIST)) {
                        this.start(output, new Ol());
                        this.olNextIndex.push(this.olNextIndex.pop() + 1);
                    } else if (parentList.equalsIgnoreCase(UNORDERED_LIST)) {
                        this.start(output, new Ul());
                    }
                }
            } else if (tag.equalsIgnoreCase(FONT)) {
                this.startFont(output, xmlReader);
            } else if (tag.equalsIgnoreCase(DIV)) {
                this.handleDiv(output);
            } else if (tag.equalsIgnoreCase("code")) {
                this.start(output, new Code());
            } else if (tag.equalsIgnoreCase("center")) {
                this.start(output, new Center());
            } else if (tag.equalsIgnoreCase("s") || tag.equalsIgnoreCase("strike")) {
                this.start(output, new Strike());
            } else if (tag.equalsIgnoreCase("tr")) {
                this.start(output, new Tr());
            } else if (tag.equalsIgnoreCase("th")) {
                this.start(output, new Th());
            } else if (tag.equalsIgnoreCase("td")) {
                this.start(output, new Td());
            }
        } else if (tag.equalsIgnoreCase(UNORDERED_LIST)) {
            this.lists.pop();
        } else if (tag.equalsIgnoreCase(ORDERED_LIST)) {
            this.lists.pop();
            this.olNextIndex.pop();
        } else if (tag.equalsIgnoreCase(LIST_ITEM)) {
            if (!this.lists.isEmpty()) {
                if (this.lists.peek().equalsIgnoreCase(UNORDERED_LIST)) {
                    if (output.length() > 0 && output.charAt(output.length() - 1) != '\n') {
                        output.append((CharSequence)"\n");
                    }
                    int bulletMargin = 10;
                    if (this.lists.size() > 1) {
                        bulletMargin = 10 - bullet.getLeadingMargin(true);
                        if (this.lists.size() > 2) {
                            bulletMargin -= (this.lists.size() - 2) * 20;
                        }
                    }
                    BulletSpan newBullet = new BulletSpan(bulletMargin);
                    this.end(output, Ul.class, false, new LeadingMarginSpan.Standard(20 * (this.lists.size() - 1)), newBullet);
                } else if (this.lists.peek().equalsIgnoreCase(ORDERED_LIST)) {
                    if (output.length() > 0 && output.charAt(output.length() - 1) != '\n') {
                        output.append((CharSequence)"\n");
                    }
                    int numberMargin = 20 * (this.lists.size() - 1);
                    if (this.lists.size() > 2) {
                        numberMargin -= (this.lists.size() - 2) * 20;
                    }
                    NumberSpan numberSpan = new NumberSpan(this.mTextPaint, (Integer)this.olNextIndex.lastElement() - 1);
                    this.end(output, Ol.class, false, new LeadingMarginSpan.Standard(numberMargin), numberSpan);
                }
            }
        } else if (tag.equalsIgnoreCase(FONT)) {
            this.endFont(output);
        } else if (tag.equalsIgnoreCase(DIV)) {
            this.handleDiv(output);
        } else if (tag.equalsIgnoreCase("code")) {
            this.end(output, Code.class, false, new TypefaceSpan("monospace"));
        } else if (tag.equalsIgnoreCase("center")) {
            this.end(output, Center.class, true, new AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER));
        } else if (tag.equalsIgnoreCase("s") || tag.equalsIgnoreCase("strike")) {
            this.end(output, Strike.class, false, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("tr")) {
            this.end(output, Tr.class, false, new Object[0]);
        } else if (tag.equalsIgnoreCase("th")) {
            this.end(output, Th.class, false, new Object[0]);
        } else if (tag.equalsIgnoreCase("td")) {
            this.end(output, Td.class, false, new Object[0]);
        }
    }

    private void start(Editable output, Object mark) {
        int len = output.length();
        output.setSpan(mark, len, len, 17);
    }

    private void end(Editable output, Class kind, boolean paragraphStyle, Object ... replaces) {
        Object obj = HtmlTagHandler.getLast(output, kind);
        int where = output.getSpanStart(obj);
        int len = output.length();
        output.removeSpan(obj);
        if (where != len) {
            int thisLen = len;
            if (paragraphStyle) {
                output.append((CharSequence)"\n");
                ++thisLen;
            }
            for (Object replace : replaces) {
                output.setSpan(replace, where, thisLen, 33);
            }
        }
    }

    private void startFont(Editable output, XMLReader xmlReader) {
        int len = output.length();
        HashMap<String, String> attributes = this.getAttributes(xmlReader);
        String color = (String)attributes.get("color");
        String size = (String)attributes.get("size");
        output.setSpan((Object)new Font(color, size), len, len, 17);
    }

    private void endFont(Editable output) {
        int len = output.length();
        Object obj = HtmlTagHandler.getLast(output, Font.class);
        int where = output.getSpanStart(obj);
        output.removeSpan(obj);
        if (where != len) {
            Font f = (Font)obj;
            int color = HtmlTagHandler.parseColor(f.color);
            int size = this.parseSize(f.size);
            if (color != -1) {
                output.setSpan((Object)new ForegroundColorSpan(color | 0xFF000000), where, len, 33);
            }
            if (size > 0) {
                output.setSpan((Object)new AbsoluteSizeSpan(size, true), where, len, 33);
            }
        }
    }

    private void handleDiv(Editable output) {
        int len = output.length();
        if (len >= 1 && output.charAt(len - 1) == '\n') {
            return;
        }
        if (len != 0) {
            output.append((CharSequence)"\n");
        }
    }

    private HashMap<String, String> getAttributes(XMLReader xmlReader) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        try {
            Field elementField = xmlReader.getClass().getDeclaredField("theNewElement");
            elementField.setAccessible(true);
            Object element = elementField.get(xmlReader);
            Field attrsField = element.getClass().getDeclaredField("theAtts");
            attrsField.setAccessible(true);
            Object attrs = attrsField.get(element);
            Field dataField = attrs.getClass().getDeclaredField("data");
            dataField.setAccessible(true);
            String[] data = (String[])dataField.get(attrs);
            Field lengthField = attrs.getClass().getDeclaredField("length");
            lengthField.setAccessible(true);
            int len = (Integer)lengthField.get(attrs);
            for (int i = 0; i < len; ++i) {
                attributes.put(data[i * 5 + 1], data[i * 5 + 4]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attributes;
    }

    private static Object getLast(Editable text, Class kind) {
        Object[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        for (int i = objs.length; i > 0; --i) {
            if (text.getSpanFlags(objs[i - 1]) != 17) continue;
            return objs[i - 1];
        }
        return null;
    }

    private static int parseColor(String colorString) {
        try {
            return Color.parseColor((String)colorString);
        }
        catch (Exception ignored) {
            return -1;
        }
    }

    private int parseSize(String size) {
        int s;
        try {
            s = Integer.parseInt(size);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
        s = Math.max(s, 1);
        s = Math.min(s, 7);
        int baseSize = this.px2dp(this.mTextPaint.getTextSize());
        return s - 3 + baseSize;
    }

    private int px2dp(float pxValue) {
        float density = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(pxValue / density + 0.5f);
    }

    private static class Font {
        public String color;
        public String size;

        public Font(String color, String size) {
            this.color = color;
            this.size = size;
        }
    }

    private static class Td {
        private Td() {
        }
    }

    private static class Th {
        private Th() {
        }
    }

    private static class Tr {
        private Tr() {
        }
    }

    private static class Strike {
        private Strike() {
        }
    }

    private static class Center {
        private Center() {
        }
    }

    private static class Code {
        private Code() {
        }
    }

    private static class Ol {
        private Ol() {
        }
    }

    private static class Ul {
        private Ul() {
        }
    }
}

