/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.bip39;

import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kethereum.bip32.BIP32;
import org.kethereum.bip32.model.ExtendedKey;
import org.kethereum.bip32.model.Seed;
import org.kethereum.bip39.MnemonicKt;
import org.kethereum.bip39.model.MnemonicWords;
import org.kethereum.crypto.CryptoAPI;
import org.kethereum.crypto.impl.kdf.PBKDF2;
import org.kethereum.extensions.BitArrayKt;
import org.komputing.khash.sha256.extensions.PublicExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u001a\u001e\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u001a\u001c\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u001a\"\u0010\r\u001a\u00020\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a&\u0010\u0011\u001a\u00020\u0012*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u001e\u0010\u0017\u001a\u00020\u0018*\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\"\u0010\u001c\u001a\u00020\u001d*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"dirtyPhraseToMnemonicWords", "Lorg/kethereum/bip39/model/MnemonicWords;", "string", "", "(Ljava/lang/String;)Ljava/util/List;", "entropyToMnemonic", "entropy", "", "wordList", "", "generateMnemonic", "strength", "", "mnemonicToEntropy", "phrase", "mnemonicToEntropy-ENmH7_k", "(Ljava/util/List;Ljava/util/List;)[B", "toKey", "Lorg/kethereum/bip32/model/ExtendedKey;", "path", "saltPhrase", "toKey-q8MP8do", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)Lorg/kethereum/bip32/model/ExtendedKey;", "toSeed", "Lorg/kethereum/bip32/model/Seed;", "password", "toSeed-d_no5WQ", "(Ljava/util/List;Ljava/lang/String;)[B", "validate", "", "validate-ENmH7_k", "(Ljava/util/List;Ljava/util/List;)Z", "bip39"})
public final class MnemonicKt {
    @NotNull
    public static final List<? extends String> dirtyPhraseToMnemonicWords(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = string;
        boolean bl = false;
        string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        return MnemonicWords.constructor-impl(SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)string4, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)), (Function1)dirtyPhraseToMnemonicWords.1.INSTANCE), (Function1)dirtyPhraseToMnemonicWords.2.INSTANCE)));
    }

    @NotNull
    public static final byte[] toSeed-d_no5WQ(@NotNull List<? extends String> $this$toSeed, @NotNull String password) {
        Intrinsics.checkNotNullParameter($this$toSeed, (String)"$this$toSeed");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String pass = CollectionsKt.joinToString$default((Iterable)$this$toSeed, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String salt = "mnemonic" + password;
        PBKDF2 pBKDF2 = CryptoAPI.INSTANCE.getPbkdf2();
        String string = pass;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        string = salt;
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return Seed.constructor-impl((byte[])PBKDF2.DefaultImpls.derive$default((PBKDF2)pBKDF2, (char[])cArray, (byte[])byArray, (int)0, null, (int)12, null));
    }

    public static /* synthetic */ byte[] toSeed-d_no5WQ$default(List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return MnemonicKt.toSeed-d_no5WQ(list, string);
    }

    @NotNull
    public static final byte[] mnemonicToEntropy(@NotNull String phrase, @NotNull List<String> wordList) {
        Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
        Intrinsics.checkNotNullParameter(wordList, (String)"wordList");
        return MnemonicKt.mnemonicToEntropy-ENmH7_k(MnemonicWords.constructor-impl(phrase), wordList);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] mnemonicToEntropy-ENmH7_k(@NotNull List<? extends String> $this$mnemonicToEntropy, @NotNull List<String> wordList) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter($this$mnemonicToEntropy, (String)"$this$mnemonicToEntropy");
        Intrinsics.checkNotNullParameter(wordList, (String)"wordList");
        boolean bl = $this$mnemonicToEntropy.size() % 3 <= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Word list size must be multiple of three words.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Collection collection = $this$mnemonicToEntropy;
        bl2 = false;
        boolean bl5 = !collection.isEmpty();
        bl2 = false;
        bl3 = false;
        if (!bl5) {
            boolean bl6 = false;
            String string = "Word list is empty.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int numTotalBits = $this$mnemonicToEntropy.size() * 11;
        boolean[] bitArray = new boolean[numTotalBits];
        bl3 = false;
        for (String word : (Iterable)$this$mnemonicToEntropy) {
            void phraseIndex;
            int dictIndex = CollectionsKt.binarySearch$default(wordList, (Comparable)((Comparable)((Object)word)), (int)0, (int)0, (int)6, null);
            int n3 = dictIndex >= 0 ? 1 : 0;
            n2 = 0;
            n = 0;
            if (n3 == 0) {
                boolean bl7 = false;
                String string = "word(" + word + ") not in known word list";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            n3 = 0;
            n2 = 10;
            while (n3 <= n2) {
                void bit;
                bitArray[phraseIndex * 11 + bit] = (dictIndex & 1 << 10 - bit) != 0;
                ++bit;
            }
            ++phraseIndex;
        }
        int numChecksumBits = numTotalBits / 33;
        int numEntropyBits = numTotalBits - numChecksumBits;
        byte[] entropy = BitArrayKt.toByteArray((boolean[])bitArray, (int)(numEntropyBits / 8));
        byte[] hash = PublicExtensionsKt.sha256((byte[])entropy);
        boolean[] hashBits = BitArrayKt.toBitArray((byte[])hash);
        n2 = 0;
        n = numChecksumBits;
        while (n2 < n) {
            void i;
            boolean bl8 = bitArray[numEntropyBits + i] == hashBits[i];
            boolean bl9 = false;
            boolean bl10 = false;
            if (!bl8) {
                boolean bl11 = false;
                String string = "mnemonic checksum does not match";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ++i;
        }
        return entropy;
    }

    @NotNull
    public static final ExtendedKey toKey-q8MP8do(@NotNull List<? extends String> $this$toKey, @NotNull String path, @NotNull String saltPhrase) {
        Intrinsics.checkNotNullParameter($this$toKey, (String)"$this$toKey");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)saltPhrase, (String)"saltPhrase");
        return BIP32.toKey-siqfMno$default((byte[])MnemonicKt.toSeed-d_no5WQ($this$toKey, saltPhrase), (String)path, (boolean)false, (int)2, null);
    }

    public static /* synthetic */ ExtendedKey toKey-q8MP8do$default(List list, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return MnemonicKt.toKey-q8MP8do(list, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String entropyToMnemonic(@NotNull byte[] entropy, @NotNull List<String> wordList) {
        Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
        Intrinsics.checkNotNullParameter(wordList, (String)"wordList");
        if (entropy.length % 4 > 0) {
            throw (Throwable)new RuntimeException("Entropy not multiple of 32 bits.");
        }
        byte[] byArray = entropy;
        boolean bl = false;
        if (byArray.length == 0) {
            throw (Throwable)new RuntimeException("Entropy is empty.");
        }
        byte[] hash = PublicExtensionsKt.sha256((byte[])entropy);
        boolean[] hashBits = BitArrayKt.toBitArray((byte[])hash);
        boolean[] entropyBits = BitArrayKt.toBitArray((byte[])entropy);
        int checksumLengthBits = entropyBits.length / 32;
        boolean[] concatBits = new boolean[entropyBits.length + checksumLengthBits];
        ArraysKt.copyInto$default((boolean[])entropyBits, (boolean[])concatBits, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.copyInto$default((boolean[])hashBits, (boolean[])concatBits, (int)entropyBits.length, (int)0, (int)checksumLengthBits, (int)4, null);
        List words = CollectionsKt.toMutableList((Collection)new ArrayList());
        int numWords = concatBits.length / 11;
        int n = 0;
        int n2 = numWords;
        while (n < n2) {
            void i;
            int index = 0;
            int n3 = 0;
            int n4 = 10;
            while (n3 <= n4) {
                void j;
                index <<= 1;
                if (concatBits[i * 11 + j]) {
                    index |= 1;
                }
                ++j;
            }
            words.add(wordList.get(index));
            ++i;
        }
        return CollectionsKt.joinToString$default((Iterable)words, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String generateMnemonic(int strength, @NotNull List<String> wordList) {
        Intrinsics.checkNotNullParameter(wordList, (String)"wordList");
        boolean bl = strength % 32 == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The entropy strength needs to be a multiple of 32";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] entropyBuffer = new byte[strength / 8];
        new SecureRandom().nextBytes(entropyBuffer);
        return MnemonicKt.entropyToMnemonic(entropyBuffer, wordList);
    }

    public static /* synthetic */ String generateMnemonic$default(int n, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 128;
        }
        return MnemonicKt.generateMnemonic(n, list);
    }

    public static final boolean validate-ENmH7_k(@NotNull List<? extends String> $this$validate, @NotNull List<String> wordList) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$validate, (String)"$this$validate");
        Intrinsics.checkNotNullParameter(wordList, (String)"wordList");
        try {
            MnemonicKt.mnemonicToEntropy-ENmH7_k($this$validate, wordList);
            bl = true;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }
}

