/*
 * Decompiled with CFR 0.152.
 */
package org.walletconnect.impls;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.File;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.walletconnect.UtilsKt;
import org.walletconnect.impls.WCSessionStore;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0002Rb\u0010\u0007\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b \f*\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t0\t \f**\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b \f*\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/walletconnect/impls/FileWCSessionStore;", "Lorg/walletconnect/impls/WCSessionStore;", "storageFile", "Ljava/io/File;", "moshi", "Lcom/squareup/moshi/Moshi;", "(Ljava/io/File;Lcom/squareup/moshi/Moshi;)V", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "", "", "Lorg/walletconnect/impls/WCSessionStore$State;", "kotlin.jvm.PlatformType", "currentStates", "", "list", "", "load", "id", "remove", "", "store", "state", "writeToFile", "lib"})
public final class FileWCSessionStore
implements WCSessionStore {
    private final JsonAdapter<Map<String, WCSessionStore.State>> adapter;
    private final Map<String, WCSessionStore.State> currentStates;
    private final File storageFile;

    @Override
    @Nullable
    public WCSessionStore.State load(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.currentStates.get(id);
    }

    @Override
    public void store(@NotNull String id, @NotNull WCSessionStore.State state) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.currentStates.put(id, state);
        this.writeToFile();
    }

    @Override
    public void remove(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.currentStates.remove(id);
        this.writeToFile();
    }

    @Override
    @NotNull
    public List<WCSessionStore.State> list() {
        return CollectionsKt.toList((Iterable)this.currentStates.values());
    }

    private final void writeToFile() {
        String string = this.adapter.toJson(this.currentStates);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"adapter.toJson(currentStates)");
        FilesKt.writeText$default((File)this.storageFile, (String)string, null, (int)2, null);
    }

    public FileWCSessionStore(@NotNull File storageFile, @NotNull Moshi moshi) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
            this.storageFile = storageFile;
            this.adapter = moshi.adapter((Type)Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])new Type[]{(Type)((Object)String.class), (Type)((Object)WCSessionStore.State.class)}));
            this.currentStates = new ConcurrentHashMap();
            final String storeContent = FilesKt.readText$default((File)this.storageFile, null, (int)1, null);
            Map map = (Map)UtilsKt.nullOnThrow((Function0)new Function0<Map<String, ? extends WCSessionStore.State>>(){

                @Nullable
                public final Map<String, WCSessionStore.State> invoke() {
                    return (Map)adapter.fromJson(storeContent);
                }
            });
            if (map == null) break block0;
            Map map2 = map;
            boolean bl = false;
            boolean bl2 = false;
            Map it = map2;
            boolean bl3 = false;
            Map map3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"it");
            this.currentStates.putAll(map3);
        }
    }
}

