/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;

public class SoundCloudHelper {
    public static String nonMobileUrl(String url) {
        if (url.startsWith("https://m.")) {
            return "https://" + url.substring("https://m.".length());
        }
        return url;
    }

    public static String loadPlaybackUrl(HttpInterface httpInterface, String jsonUrl) throws IOException {
        try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, URI.create(jsonUrl), null);){
            if (!HttpClientTools.isSuccessWithContent(stream.checkStatusCode())) {
                throw new IOException("Invalid status code for soundcloud stream: " + stream.checkStatusCode());
            }
            JsonBrowser json = JsonBrowser.parse(stream);
            String string = json.get("url").text();
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AudioReference redirectMobileLink(HttpInterface httpInterface, AudioReference reference) {
        try (CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)new HttpGet(reference.identifier));){
            HttpClientTools.assertSuccessWithContent((HttpResponse)response, "mobile redirect response");
            HttpClientContext context = httpInterface.getContext();
            List redirects = context.getRedirectLocations();
            if (redirects != null && !redirects.isEmpty()) {
                AudioReference audioReference = new AudioReference(((URI)redirects.get(0)).toString(), null);
                return audioReference;
            }
            throw new FriendlyException("Unable to process soundcloud mobile link", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Expected soundcloud to redirect soundcloud.app.goo.gl link to a valid track/playlist link, but it did not redirect at all"));
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions(e);
        }
    }
}

