/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.remote.message;

import com.sedmelluq.discord.lavaplayer.remote.message.RemoteMessage;
import com.sedmelluq.discord.lavaplayer.remote.message.RemoteMessageCodec;
import com.sedmelluq.discord.lavaplayer.remote.message.RemoteMessageType;
import com.sedmelluq.discord.lavaplayer.remote.message.UnknownMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMessageMapper {
    private static final Logger log = LoggerFactory.getLogger(RemoteMessageMapper.class);
    private final Map<Class<? extends RemoteMessage>, RemoteMessageType> encodingMap = new IdentityHashMap<Class<? extends RemoteMessage>, RemoteMessageType>();

    public RemoteMessageMapper() {
        this.initialiseEncodingMap();
    }

    private void initialiseEncodingMap() {
        for (RemoteMessageType type : (RemoteMessageType[])RemoteMessageType.class.getEnumConstants()) {
            this.encodingMap.put(type.codec.getMessageClass(), type);
        }
    }

    public RemoteMessage decode(DataInput input) throws IOException {
        int messageSize = input.readInt();
        if (messageSize == 0) {
            return null;
        }
        RemoteMessageType[] types = (RemoteMessageType[])RemoteMessageType.class.getEnumConstants();
        int typeIndex = input.readByte() & 0xFF;
        int version = input.readByte() & 0xFF;
        if (typeIndex >= types.length) {
            log.warn("Invalid message type {}.", (Object)typeIndex);
            input.readFully(new byte[messageSize - 1]);
            return UnknownMessage.INSTANCE;
        }
        RemoteMessageType type = types[typeIndex];
        if (version < 1 || version > type.codec.version(null)) {
            log.warn("Invalid version {} for message {}.", (Object)version, (Object)type);
            input.readFully(new byte[messageSize - 2]);
            return UnknownMessage.INSTANCE;
        }
        return type.codec.decode(input, version);
    }

    public void encode(DataOutputStream output, RemoteMessage message) throws IOException {
        RemoteMessageType type = this.encodingMap.get(message.getClass());
        ByteArrayOutputStream messageOutputBytes = new ByteArrayOutputStream();
        DataOutputStream messageOutput = new DataOutputStream(messageOutputBytes);
        RemoteMessageCodec<?> codec = type.codec;
        codec.encode(messageOutput, message);
        output.writeInt(messageOutputBytes.size() + 2);
        output.writeByte((byte)type.ordinal());
        output.writeByte((byte)type.codec.version(message));
        messageOutputBytes.writeTo(output);
    }

    public void endOutput(DataOutputStream output) throws IOException {
        output.writeInt(0);
    }
}

