/*
 * Decompiled with CFR 0.152.
 */
package waffle.mock;

import java.util.ArrayList;
import java.util.List;
import waffle.mock.MockWindowsAccount;
import waffle.mock.MockWindowsImpersonationContext;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsImpersonationContext;

public class MockWindowsIdentity
implements IWindowsIdentity {
    private final String fqn;
    private final List<String> groups;

    public MockWindowsIdentity(String newFqn, List<String> newGroups) {
        this.fqn = newFqn;
        this.groups = newGroups;
    }

    public String getFqn() {
        return this.fqn;
    }

    public IWindowsAccount[] getGroups() {
        ArrayList<MockWindowsAccount> groupsList = new ArrayList<MockWindowsAccount>();
        for (String group : this.groups) {
            groupsList.add(new MockWindowsAccount(group));
        }
        return groupsList.toArray(new IWindowsAccount[0]);
    }

    public byte[] getSid() {
        return new byte[0];
    }

    public String getSidString() {
        return "S-" + this.fqn.hashCode();
    }

    public void dispose() {
    }

    public boolean isGuest() {
        return "Guest".equals(this.fqn);
    }

    public IWindowsImpersonationContext impersonate() {
        return new MockWindowsImpersonationContext();
    }
}

