/*
 * Decompiled with CFR 0.152.
 */
package waffle.mock.http;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.mockito.Mockito;
import waffle.mock.http.SimpleHttpSession;

public class SimpleHttpRequest
extends HttpServletRequestWrapper {
    private static int remotePortS = 0;
    private String requestURI;
    private String queryString;
    private String remoteUser;
    private String method = "GET";
    private String remoteHost;
    private String remoteAddr;
    private int remotePort = -1;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, String> parameters = new HashMap<String, String>();
    private byte[] content;
    private HttpSession session = new SimpleHttpSession();
    private Principal principal;

    public SimpleHttpRequest() {
        super((HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        this.remotePort = SimpleHttpRequest.nextRemotePort();
    }

    public static synchronized int nextRemotePort() {
        return ++remotePortS;
    }

    public static synchronized void resetRemotePort() {
        remotePortS = 0;
    }

    public void addHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
    }

    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public String getMethod() {
        return this.method;
    }

    public int getContentLength() {
        return this.content == null ? -1 : this.content.length;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setMethod(String methodName) {
        this.method = methodName;
    }

    public void setContentLength(int length) {
        this.content = new byte[length];
    }

    public void setRemoteUser(String username) {
        this.remoteUser = username;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpSession getSession(boolean create) {
        if (this.session == null && create) {
            this.session = new SimpleHttpSession();
        }
        return this.session;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String query) {
        this.queryString = query;
        if (this.queryString != null) {
            for (String eachParameter : this.queryString.split("&", -1)) {
                String[] pair = eachParameter.split("=", -1);
                String value = pair.length == 2 ? pair[1] : "";
                this.addParameter(pair[0], value);
            }
        }
    }

    public void setRequestURI(String uri) {
        this.requestURI = uri;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getParameter(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public void addParameter(String parameterName, String parameterValue) {
        this.parameters.put(parameterName, parameterValue);
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String value) {
        this.remoteHost = value;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String value) {
        this.remoteAddr = value;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public void setUserPrincipal(Principal value) {
        this.principal = value;
    }
}

