/*
 * Decompiled with CFR 0.152.
 */
package waffle.spring;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;
import waffle.servlet.AutoDisposableWindowsPrincipal;
import waffle.servlet.WindowsPrincipal;
import waffle.servlet.spi.SecurityFilterProviderCollection;
import waffle.spring.GrantedAuthorityFactory;
import waffle.spring.WindowsAuthenticationToken;
import waffle.util.AuthorizationHeader;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsImpersonationContext;
import waffle.windows.auth.PrincipalFormat;

public class NegotiateSecurityFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(NegotiateSecurityFilter.class);
    private SecurityFilterProviderCollection provider;
    private PrincipalFormat principalFormat = PrincipalFormat.FQN;
    private PrincipalFormat roleFormat = PrincipalFormat.FQN;
    private boolean allowGuestLogin = true;
    private boolean impersonate;
    private GrantedAuthorityFactory grantedAuthorityFactory = WindowsAuthenticationToken.DEFAULT_GRANTED_AUTHORITY_FACTORY;
    private GrantedAuthority defaultGrantedAuthority = WindowsAuthenticationToken.DEFAULT_GRANTED_AUTHORITY;

    public NegotiateSecurityFilter() {
        LOGGER.debug("[waffle.spring.NegotiateSecurityFilter] loaded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        LOGGER.debug("{} {}, contentlength: {}", new Object[]{request.getMethod(), request.getRequestURI(), request.getContentLength()});
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(request);
        if (!authorizationHeader.isNull() && this.provider.isSecurityPackageSupported(authorizationHeader.getSecurityPackage())) {
            IWindowsIdentity windowsIdentity;
            try {
                windowsIdentity = this.provider.doFilter(request, response);
                if (windowsIdentity == null) {
                    return;
                }
            }
            catch (IOException e) {
                LOGGER.warn("error logging in user: {}", (Object)e.getMessage());
                LOGGER.trace("", (Throwable)e);
                this.sendUnauthorized(response, true);
                return;
            }
            IWindowsImpersonationContext ctx = null;
            try {
                if (!this.allowGuestLogin && windowsIdentity.isGuest()) {
                    LOGGER.warn("guest login disabled: {}", (Object)windowsIdentity.getFqn());
                    this.sendUnauthorized(response, true);
                    return;
                }
                LOGGER.debug("logged in user: {} ({})", (Object)windowsIdentity.getFqn(), (Object)windowsIdentity.getSidString());
                AutoDisposableWindowsPrincipal principal = this.impersonate ? new AutoDisposableWindowsPrincipal(windowsIdentity, this.principalFormat, this.roleFormat) : new WindowsPrincipal(windowsIdentity, this.principalFormat, this.roleFormat);
                LOGGER.debug("roles: {}", (Object)principal.getRolesString());
                WindowsAuthenticationToken authentication = new WindowsAuthenticationToken((WindowsPrincipal)principal, this.grantedAuthorityFactory, this.defaultGrantedAuthority);
                if (!this.setAuthentication(request, response, authentication)) {
                    return;
                }
                LOGGER.info("successfully logged in user: {}", (Object)windowsIdentity.getFqn());
                if (this.impersonate) {
                    LOGGER.debug("impersonating user");
                    ctx = windowsIdentity.impersonate();
                }
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                if (this.impersonate && ctx != null) {
                    LOGGER.debug("terminating impersonation");
                    ctx.revertToSelf();
                } else {
                    windowsIdentity.dispose();
                }
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean setAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        SecurityContextHolder.getContext().setAuthentication(authentication);
        return true;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        if (this.provider == null) {
            throw new ServletException("Missing NegotiateSecurityFilter.Provider");
        }
    }

    protected void sendUnauthorized(HttpServletResponse response, boolean close) {
        try {
            this.provider.sendUnauthorized(response);
            if (close) {
                response.setHeader("Connection", "close");
            } else {
                response.setHeader("Connection", "keep-alive");
            }
            response.sendError(401);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PrincipalFormat getPrincipalFormat() {
        return this.principalFormat;
    }

    public void setPrincipalFormatEnum(PrincipalFormat value) {
        this.principalFormat = value;
    }

    public void setPrincipalFormat(String value) {
        this.setPrincipalFormatEnum(PrincipalFormat.valueOf((String)value.toUpperCase(Locale.ENGLISH)));
    }

    public PrincipalFormat getRoleFormat() {
        return this.roleFormat;
    }

    public void setRoleFormatEnum(PrincipalFormat value) {
        this.roleFormat = value;
    }

    public void setRoleFormat(String value) {
        this.setRoleFormatEnum(PrincipalFormat.valueOf((String)value.toUpperCase(Locale.ENGLISH)));
    }

    public boolean isAllowGuestLogin() {
        return this.allowGuestLogin;
    }

    public void setAllowGuestLogin(boolean value) {
        this.allowGuestLogin = value;
    }

    public void setImpersonate(boolean value) {
        this.impersonate = value;
    }

    public boolean isImpersonate() {
        return this.impersonate;
    }

    public SecurityFilterProviderCollection getProvider() {
        return this.provider;
    }

    public void setProvider(SecurityFilterProviderCollection value) {
        this.provider = value;
    }

    public GrantedAuthorityFactory getGrantedAuthorityFactory() {
        return this.grantedAuthorityFactory;
    }

    public void setGrantedAuthorityFactory(GrantedAuthorityFactory value) {
        this.grantedAuthorityFactory = value;
    }

    public GrantedAuthority getDefaultGrantedAuthority() {
        return this.defaultGrantedAuthority;
    }

    public void setDefaultGrantedAuthority(GrantedAuthority value) {
        this.defaultGrantedAuthority = value;
    }
}

