/*
 * Decompiled with CFR 0.152.
 */
package waffle.shiro;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import waffle.shiro.AbstractWaffleRealm;
import waffle.shiro.WaffleFqnPrincipal;

public class GroupMappingWaffleRealm
extends AbstractWaffleRealm {
    private final Map<String, String> groupRolesMap = new HashMap<String, String>();

    public void setGroupRolesMap(Map<String, String> value) {
        this.groupRolesMap.clear();
        if (value != null) {
            this.groupRolesMap.putAll(value);
        }
    }

    protected Collection<String> getRoleNamesForGroups(Collection<String> groupNames) {
        HashSet<String> roleNames = new HashSet<String>();
        for (String groupName : groupNames) {
            String roleName = this.groupRolesMap.get(groupName);
            if (roleName == null) continue;
            roleNames.add(roleName);
        }
        return roleNames;
    }

    @Override
    protected AuthorizationInfo buildAuthorizationInfo(WaffleFqnPrincipal principal) {
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        authorizationInfo.addRoles(this.getRoleNamesForGroups(principal.getGroupFqns()));
        return authorizationInfo;
    }
}

