/*
 * Decompiled with CFR 0.152.
 */
package waffle.shiro.negotiate;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.HostAuthenticationToken;
import org.apache.shiro.authc.RememberMeAuthenticationToken;
import waffle.shiro.negotiate.NegotiateInfo;

public class NegotiateToken
implements HostAuthenticationToken,
RememberMeAuthenticationToken {
    private static final long serialVersionUID = 1345343228636916781L;
    private final byte[] in;
    private byte[] out;
    private Subject subject;
    private Principal principal;
    private final String connectionId;
    private final String securityPackage;
    private final boolean ntlmPost;
    private final boolean rememberMe;
    private final String host;

    public NegotiateToken(byte[] newIn, byte[] newOut, String newConnectionId, String newSecurityPackage, boolean newNtlmPost, boolean newRememberMe, String newHost) {
        this.in = newIn;
        this.out = newOut;
        this.connectionId = newConnectionId;
        this.securityPackage = newSecurityPackage;
        this.ntlmPost = newNtlmPost;
        this.rememberMe = newRememberMe;
        this.host = newHost;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getSecurityPackage() {
        return this.securityPackage;
    }

    public boolean isNtlmPost() {
        return this.ntlmPost;
    }

    public Object getCredentials() {
        return this.subject;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    byte[] getOut() {
        return this.out;
    }

    public void setOut(byte[] outToken) {
        this.out = outToken != null ? (byte[])outToken.clone() : null;
    }

    public void setSubject(Subject value) {
        this.subject = value;
    }

    public byte[] getIn() {
        return (byte[])this.in.clone();
    }

    public Subject getSubject() {
        return this.subject;
    }

    public AuthenticationInfo createInfo() {
        return new NegotiateInfo(this.subject, "NegotiateWaffleRealm");
    }

    public void setPrincipal(Principal value) {
        this.principal = value;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public String getHost() {
        return this.host;
    }
}

