/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet.spi;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.util.AuthorizationHeader;
import waffle.util.NtlmServletRequest;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;

public class NegotiateSecurityFilterProvider
implements SecurityFilterProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NegotiateSecurityFilterProvider.class);
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String PROTOCOLS = "protocols";
    private static final String NEGOTIATE = "Negotiate";
    private static final String NTLM = "NTLM";
    private List<String> protocols = new ArrayList<String>();
    private final IWindowsAuthProvider auth;

    public NegotiateSecurityFilterProvider(IWindowsAuthProvider newAuthProvider) {
        this.auth = newAuthProvider;
        this.protocols.add(NEGOTIATE);
        this.protocols.add(NTLM);
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<String> values) {
        this.protocols = values;
    }

    @Override
    public void sendUnauthorized(HttpServletResponse response) {
        Iterator<String> protocolsIterator = this.protocols.iterator();
        while (protocolsIterator.hasNext()) {
            response.addHeader(WWW_AUTHENTICATE, protocolsIterator.next());
        }
    }

    @Override
    public boolean isPrincipalException(HttpServletRequest request) {
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(request);
        boolean ntlmPost = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        LOGGER.debug("authorization: {}, ntlm post: {}", (Object)authorizationHeader, (Object)ntlmPost);
        return ntlmPost;
    }

    @Override
    public IWindowsIdentity doFilter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(request);
        boolean ntlmPost = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        String connectionId = NtlmServletRequest.getConnectionId(request);
        String securityPackage = authorizationHeader.getSecurityPackage();
        LOGGER.debug("security package: {}, connection id: {}", (Object)securityPackage, (Object)connectionId);
        if (ntlmPost) {
            this.auth.resetSecurityToken(connectionId);
        }
        byte[] tokenBuffer = authorizationHeader.getTokenBytes();
        LOGGER.debug("token buffer: {} byte(s)", (Object)tokenBuffer.length);
        IWindowsSecurityContext securityContext = this.auth.acceptSecurityToken(connectionId, tokenBuffer, securityPackage);
        byte[] continueTokenBytes = securityContext.getToken();
        if (continueTokenBytes != null && continueTokenBytes.length > 0) {
            String continueToken = BaseEncoding.base64().encode(continueTokenBytes);
            LOGGER.debug("continue token: {}", (Object)continueToken);
            response.addHeader(WWW_AUTHENTICATE, securityPackage + " " + continueToken);
        }
        LOGGER.debug("continue required: {}", (Object)securityContext.isContinue());
        if (securityContext.isContinue() || ntlmPost) {
            response.setHeader("Connection", "keep-alive");
            response.setStatus(401);
            response.flushBuffer();
            return null;
        }
        IWindowsIdentity identity = securityContext.getIdentity();
        securityContext.dispose();
        return identity;
    }

    @Override
    public boolean isSecurityPackageSupported(String securityPackage) {
        for (String protocol : this.protocols) {
            if (!protocol.equalsIgnoreCase(securityPackage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initParameter(String parameterName, String parameterValue) {
        if (parameterName.equals(PROTOCOLS)) {
            String[] protocolNames;
            this.protocols = new ArrayList<String>();
            for (String protocolName : protocolNames = parameterValue.split("\\s+")) {
                if ((protocolName = protocolName.trim()).length() <= 0) continue;
                LOGGER.debug("init protocol: {}", (Object)protocolName);
                if (protocolName.equals(NEGOTIATE) || protocolName.equals(NTLM)) {
                    this.protocols.add(protocolName);
                    continue;
                }
                LOGGER.error("unsupported protocol: {}", (Object)protocolName);
                throw new RuntimeException("Unsupported protocol: " + protocolName);
            }
        } else {
            throw new InvalidParameterException(parameterName);
        }
    }
}

