/*
 * Decompiled with CFR 0.152.
 */
package waffle.jaas;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import waffle.jaas.UserPrincipal;

public class GroupPrincipal
extends UserPrincipal
implements Group {
    private static final long serialVersionUID = 1L;
    private final String fqn;
    private final Map<Principal, Principal> members;

    public GroupPrincipal(String fqn) {
        super(fqn);
        this.fqn = fqn;
        this.members = new HashMap<Principal, Principal>();
    }

    @Override
    public String getName() {
        return this.fqn;
    }

    public boolean addMember(Principal user) {
        boolean isMember = this.members.containsKey(user);
        if (!isMember) {
            this.members.put(user, user);
        }
        return isMember;
    }

    public boolean isMember(Principal user) {
        boolean isMember = this.members.containsKey(user);
        if (!isMember) {
            Collection<Principal> values = this.members.values();
            Iterator<Principal> iter = values.iterator();
            while (!isMember && iter.hasNext()) {
                Principal next = iter.next();
                if (!(next instanceof Group)) continue;
                Group group = (Group)next;
                isMember = group.isMember(user);
            }
        }
        return isMember;
    }

    public Enumeration<? extends Principal> members() {
        return Collections.enumeration(this.members.values());
    }

    public boolean removeMember(Principal user) {
        Principal prev = this.members.remove(user);
        return prev != null;
    }

    @Override
    public String toString() {
        StringBuffer tmp = new StringBuffer(this.getName());
        tmp.append("(members:");
        Iterator<Principal> iter = this.members.keySet().iterator();
        while (iter.hasNext()) {
            tmp.append(iter.next());
            tmp.append(',');
        }
        tmp.setCharAt(tmp.length() - 1, ')');
        return tmp.toString();
    }
}

