/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import java.util.List;

public class SoftKeyboardSizeWatchLayout
extends RelativeLayout {
    private Context mContext;
    private int mOldh = -1;
    private int mNowh = -1;
    protected int mScreenHeight = 0;
    protected boolean mIsSoftKeyboardPop = false;
    private List<OnResizeListener> mListenerList;

    public SoftKeyboardSizeWatchLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Rect r = new Rect();
                ((Activity)SoftKeyboardSizeWatchLayout.this.mContext).getWindow().getDecorView().getWindowVisibleDisplayFrame(r);
                if (SoftKeyboardSizeWatchLayout.this.mScreenHeight == 0) {
                    SoftKeyboardSizeWatchLayout.this.mScreenHeight = r.bottom;
                }
                SoftKeyboardSizeWatchLayout.this.mNowh = SoftKeyboardSizeWatchLayout.this.mScreenHeight - r.bottom;
                if (SoftKeyboardSizeWatchLayout.this.mOldh != -1 && SoftKeyboardSizeWatchLayout.this.mNowh != SoftKeyboardSizeWatchLayout.this.mOldh) {
                    if (SoftKeyboardSizeWatchLayout.this.mNowh > 0) {
                        SoftKeyboardSizeWatchLayout.this.mIsSoftKeyboardPop = true;
                        if (SoftKeyboardSizeWatchLayout.this.mListenerList != null) {
                            for (OnResizeListener l : SoftKeyboardSizeWatchLayout.this.mListenerList) {
                                l.OnSoftPop(SoftKeyboardSizeWatchLayout.this.mNowh);
                            }
                        }
                    } else {
                        SoftKeyboardSizeWatchLayout.this.mIsSoftKeyboardPop = false;
                        if (SoftKeyboardSizeWatchLayout.this.mListenerList != null) {
                            for (OnResizeListener l : SoftKeyboardSizeWatchLayout.this.mListenerList) {
                                l.OnSoftClose();
                            }
                        }
                    }
                }
                SoftKeyboardSizeWatchLayout.this.mOldh = SoftKeyboardSizeWatchLayout.this.mNowh;
            }
        });
    }

    public boolean isSoftKeyboardPop() {
        return this.mIsSoftKeyboardPop;
    }

    public void addOnResizeListener(OnResizeListener l) {
        if (this.mListenerList == null) {
            this.mListenerList = new ArrayList<OnResizeListener>();
        }
        this.mListenerList.add(l);
    }

    public static interface OnResizeListener {
        public void OnSoftPop(int var1);

        public void OnSoftClose();
    }
}

