/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.keyboard.view.R;
import sj.keyboard.utils.EmoticonsKeyboardUtils;
import sj.keyboard.widget.SoftKeyboardSizeWatchLayout;

public abstract class AutoHeightLayout
extends SoftKeyboardSizeWatchLayout
implements SoftKeyboardSizeWatchLayout.OnResizeListener {
    private static final int ID_CHILD = R.id.id_autolayout;
    protected int mSoftKeyboardHeight;
    protected int mMaxParentHeight;
    protected Context mContext;
    private OnMaxParentHeightChangeListener maxParentHeightChangeListener;

    public AutoHeightLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mSoftKeyboardHeight = EmoticonsKeyboardUtils.getDefKeyboardHeight(this.mContext);
        this.addOnResizeListener(this);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        int childSum = this.getChildCount();
        if (childSum > 1) {
            throw new IllegalStateException("can host only one direct child");
        }
        super.addView(child, index, params);
        if (childSum == 0) {
            if (child.getId() < 0) {
                child.setId(ID_CHILD);
            }
            RelativeLayout.LayoutParams paramsChild = (RelativeLayout.LayoutParams)child.getLayoutParams();
            paramsChild.addRule(12);
            child.setLayoutParams((ViewGroup.LayoutParams)paramsChild);
        } else if (childSum == 1) {
            RelativeLayout.LayoutParams paramsChild = (RelativeLayout.LayoutParams)child.getLayoutParams();
            paramsChild.addRule(2, ID_CHILD);
            child.setLayoutParams((ViewGroup.LayoutParams)paramsChild);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.onSoftKeyboardHeightChanged(this.mSoftKeyboardHeight);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mMaxParentHeight == 0) {
            this.mMaxParentHeight = h;
        }
    }

    public void updateMaxParentHeight(int maxParentHeight) {
        this.mMaxParentHeight = maxParentHeight;
        if (this.maxParentHeightChangeListener != null) {
            this.maxParentHeightChangeListener.onMaxParentHeightChange(maxParentHeight);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mMaxParentHeight != 0) {
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int expandSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxParentHeight, (int)heightMode);
            super.onMeasure(widthMeasureSpec, expandSpec);
            return;
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void OnSoftPop(int height) {
        if (this.mSoftKeyboardHeight != height) {
            this.mSoftKeyboardHeight = height;
            EmoticonsKeyboardUtils.setDefKeyboardHeight(this.mContext, this.mSoftKeyboardHeight);
            this.onSoftKeyboardHeightChanged(this.mSoftKeyboardHeight);
        }
    }

    @Override
    public void OnSoftClose() {
    }

    public abstract void onSoftKeyboardHeightChanged(int var1);

    public void setOnMaxParentHeightChangeListener(OnMaxParentHeightChangeListener listener) {
        this.maxParentHeightChangeListener = listener;
    }

    public static interface OnMaxParentHeightChangeListener {
        public void onMaxParentHeightChange(int var1);
    }
}

