/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.widget;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import sj.keyboard.adpater.PageSetAdapter;
import sj.keyboard.data.PageSetEntity;

public class EmoticonsFuncView
extends ViewPager {
    protected PageSetAdapter mPageSetAdapter;
    protected int mCurrentPagePosition;
    private OnEmoticonsPageViewListener mOnEmoticonsPageViewListener;

    public EmoticonsFuncView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setAdapter(PageSetAdapter adapter) {
        super.setAdapter((PagerAdapter)adapter);
        this.mPageSetAdapter = adapter;
        this.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                EmoticonsFuncView.this.checkPageChange(position);
                EmoticonsFuncView.this.mCurrentPagePosition = position;
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        if (this.mOnEmoticonsPageViewListener == null || this.mPageSetAdapter.getPageSetEntityList().isEmpty()) {
            return;
        }
        PageSetEntity pageSetEntity = this.mPageSetAdapter.getPageSetEntityList().get(0);
        this.mOnEmoticonsPageViewListener.playTo(0, pageSetEntity);
        this.mOnEmoticonsPageViewListener.emoticonSetChanged(pageSetEntity);
    }

    public void setCurrentPageSet(PageSetEntity pageSetEntity) {
        if (this.mPageSetAdapter == null || this.mPageSetAdapter.getCount() <= 0) {
            return;
        }
        this.setCurrentItem(this.mPageSetAdapter.getPageSetStartPosition(pageSetEntity));
    }

    public void checkPageChange(int position) {
        if (this.mPageSetAdapter == null) {
            return;
        }
        int end = 0;
        for (PageSetEntity pageSetEntity : this.mPageSetAdapter.getPageSetEntityList()) {
            int size = pageSetEntity.getPageCount();
            if (end + size > position) {
                boolean isEmoticonSetChanged = true;
                if (this.mCurrentPagePosition - end >= size) {
                    if (this.mOnEmoticonsPageViewListener != null) {
                        this.mOnEmoticonsPageViewListener.playTo(position - end, pageSetEntity);
                    }
                } else if (this.mCurrentPagePosition - end < 0) {
                    if (this.mOnEmoticonsPageViewListener != null) {
                        this.mOnEmoticonsPageViewListener.playTo(0, pageSetEntity);
                    }
                } else {
                    if (this.mOnEmoticonsPageViewListener != null) {
                        this.mOnEmoticonsPageViewListener.playBy(this.mCurrentPagePosition - end, position - end, pageSetEntity);
                    }
                    isEmoticonSetChanged = false;
                }
                if (isEmoticonSetChanged && this.mOnEmoticonsPageViewListener != null) {
                    this.mOnEmoticonsPageViewListener.emoticonSetChanged(pageSetEntity);
                }
                return;
            }
            end += size;
        }
    }

    public void setOnIndicatorListener(OnEmoticonsPageViewListener listener) {
        this.mOnEmoticonsPageViewListener = listener;
    }

    public static interface OnEmoticonsPageViewListener {
        public void emoticonSetChanged(PageSetEntity var1);

        public void playTo(int var1, PageSetEntity var2);

        public void playBy(int var1, int var2, PageSetEntity var3);
    }
}

