/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.data;

import java.util.ArrayList;
import sj.keyboard.data.EmoticonPageEntity;
import sj.keyboard.data.PageSetEntity;
import sj.keyboard.interfaces.PageViewInstantiateListener;

public class EmoticonPageSetEntity<T>
extends PageSetEntity<EmoticonPageEntity> {
    final int mLine;
    final int mRow;
    final EmoticonPageEntity.DelBtnStatus mDelBtnStatus;
    final ArrayList<T> mEmoticonList;

    public EmoticonPageSetEntity(Builder builder) {
        super(builder);
        this.mLine = builder.line;
        this.mRow = builder.row;
        this.mDelBtnStatus = builder.delBtnStatus;
        this.mEmoticonList = builder.emoticonList;
    }

    public int getLine() {
        return this.mLine;
    }

    public int getRow() {
        return this.mRow;
    }

    public EmoticonPageEntity.DelBtnStatus getDelBtnStatus() {
        return this.mDelBtnStatus;
    }

    public ArrayList<T> getEmoticonList() {
        return this.mEmoticonList;
    }

    public static class Builder<T>
    extends PageSetEntity.Builder {
        protected int line;
        protected int row;
        protected EmoticonPageEntity.DelBtnStatus delBtnStatus = EmoticonPageEntity.DelBtnStatus.GONE;
        protected ArrayList<T> emoticonList;
        protected PageViewInstantiateListener pageViewInstantiateListener;

        public Builder setLine(int line) {
            this.line = line;
            return this;
        }

        public Builder setRow(int row) {
            this.row = row;
            return this;
        }

        public Builder setShowDelBtn(EmoticonPageEntity.DelBtnStatus showDelBtn) {
            this.delBtnStatus = showDelBtn;
            return this;
        }

        public Builder setEmoticonList(ArrayList<T> emoticonList) {
            this.emoticonList = emoticonList;
            return this;
        }

        public Builder setIPageViewInstantiateItem(PageViewInstantiateListener pageViewInstantiateListener) {
            this.pageViewInstantiateListener = pageViewInstantiateListener;
            return this;
        }

        @Override
        public Builder setShowIndicator(boolean showIndicator) {
            this.isShowIndicator = showIndicator;
            return this;
        }

        @Override
        public Builder setIconUri(String iconUri) {
            this.iconUri = iconUri;
            return this;
        }

        @Override
        public Builder setSetName(String setName) {
            this.setName = setName;
            return this;
        }

        public EmoticonPageSetEntity<T> build() {
            int end;
            int emoticonSetSum = this.emoticonList.size();
            int del = this.delBtnStatus.isShow() ? 1 : 0;
            int everyPageMaxSum = this.row * this.line - del;
            this.pageCount = (int)Math.ceil((double)this.emoticonList.size() / (double)everyPageMaxSum);
            int start = 0;
            int n = end = everyPageMaxSum > emoticonSetSum ? emoticonSetSum : everyPageMaxSum;
            if (!this.pageEntityList.isEmpty()) {
                this.pageEntityList.clear();
            }
            for (int i = 0; i < this.pageCount; ++i) {
                EmoticonPageEntity<T> emoticonPageEntity = new EmoticonPageEntity<T>();
                emoticonPageEntity.setLine(this.line);
                emoticonPageEntity.setRow(this.row);
                emoticonPageEntity.setDelBtnStatus(this.delBtnStatus);
                emoticonPageEntity.setEmoticonList(this.emoticonList.subList(start, end));
                emoticonPageEntity.setIPageViewInstantiateItem(this.pageViewInstantiateListener);
                this.pageEntityList.add(emoticonPageEntity);
                start = everyPageMaxSum + i * everyPageMaxSum;
                end = everyPageMaxSum + (i + 1) * everyPageMaxSum;
                if (end < emoticonSetSum) continue;
                end = emoticonSetSum;
            }
            return new EmoticonPageSetEntity(this);
        }
    }
}

