/*
 * Decompiled with CFR 0.152.
 */
package sj.keyboard.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Paint;
import android.preference.PreferenceManager;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;

public class EmoticonsKeyboardUtils {
    private static final String EXTRA_DEF_KEYBOARDHEIGHT = "DEF_KEYBOARDHEIGHT";
    private static final int DEF_KEYBOARD_HEAGH_WITH_DP = 300;
    private static int sDefKeyboardHeight = -1;

    private static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(dm);
        return dm;
    }

    public static int getDisplayWidthPixels(Context context) {
        return EmoticonsKeyboardUtils.getDisplayMetrics((Context)context).widthPixels;
    }

    public static int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int getFontHeight(TextView textView) {
        Paint paint = new Paint();
        paint.setTextSize(textView.getTextSize());
        Paint.FontMetrics fm = paint.getFontMetrics();
        return (int)Math.ceil(fm.bottom - fm.top);
    }

    public static View getRootView(Activity context) {
        return ((ViewGroup)context.findViewById(0x1020002)).getChildAt(0);
    }

    public static int getDefKeyboardHeight(Context context) {
        int height;
        if (sDefKeyboardHeight < 0) {
            sDefKeyboardHeight = EmoticonsKeyboardUtils.dip2px(context, 300.0f);
        }
        sDefKeyboardHeight = (height = PreferenceManager.getDefaultSharedPreferences((Context)context).getInt(EXTRA_DEF_KEYBOARDHEIGHT, 0)) > 0 && sDefKeyboardHeight != height ? height : sDefKeyboardHeight;
        return sDefKeyboardHeight;
    }

    public static void setDefKeyboardHeight(Context context, int height) {
        if (sDefKeyboardHeight != height) {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putInt(EXTRA_DEF_KEYBOARDHEIGHT, height).commit();
            sDefKeyboardHeight = height;
        }
    }

    public static void openSoftKeyboard(EditText et) {
        if (et != null) {
            et.setFocusable(true);
            et.setFocusableInTouchMode(true);
            et.requestFocus();
            InputMethodManager inputManager = (InputMethodManager)et.getContext().getSystemService("input_method");
            inputManager.showSoftInput((View)et, 0);
        }
    }

    public static void closeSoftKeyboard(Context context) {
        if (context == null || !(context instanceof Activity) || ((Activity)context).getCurrentFocus() == null) {
            return;
        }
        try {
            InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(((Activity)context).getCurrentFocus().getWindowToken(), 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

