/*
 * Decompiled with CFR 0.152.
 */
package com.sj.emoji;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Spannable;
import android.view.View;
import android.widget.TextView;
import com.sj.emoji.EmojiAsyncLoadTextView;
import com.sj.emoji.EmojiDisplayListener;
import com.sj.emoji.EmojiDrawable;
import com.sj.emoji.EmojiSpan;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmojiDisplay {
    private static final Pattern EMOJI_RANGE = Pattern.compile("[\\u203c\\u2049\\u20a0-\\u32ff\\ud83c\\udc00-\\ud83d\\udeff\\udbb9\\udce5-\\udbb9\\udcee]");
    public static final String HEAD_NAME = "emoji_0x";
    public static final int WRAP_DRAWABLE = -1;

    public static Matcher getMatcher(CharSequence matchStr) {
        return EMOJI_RANGE.matcher(matchStr);
    }

    public static Spannable filterFromFile(Spannable spannable, int fontSize, String filePath, EmojiDisplayListener emojiDisplayListener) {
        if (spannable == null) {
            return null;
        }
        Matcher m = EmojiDisplay.getMatcher(spannable.toString());
        if (m != null) {
            while (m.find()) {
                String emojiHex = Integer.toHexString(Character.codePointAt(m.group(), 0));
                if (emojiDisplayListener == null) {
                    Drawable drawable = Drawable.createFromPath((String)(filePath + emojiHex + ".png"));
                    if (drawable == null) continue;
                    drawable.setBounds(0, 0, fontSize, fontSize);
                    EmojiSpan imageSpan = new EmojiSpan(drawable);
                    spannable.setSpan((Object)imageSpan, m.start(), m.end(), 17);
                    continue;
                }
                emojiDisplayListener.onEmojiDisplay(null, spannable, emojiHex, fontSize, m.start(), m.end());
            }
        }
        return spannable;
    }

    public static Spannable filterAsyncFromFile(Spannable spannable, int fontSize, String filePath, EmojiAsyncLoadTextView emojiAsyncLoadTextView) {
        if (spannable == null) {
            return null;
        }
        Matcher m = EmojiDisplay.getMatcher(spannable.toString());
        if (m != null) {
            while (m.find()) {
                String emojiHex = Integer.toHexString(Character.codePointAt(m.group(), 0));
                EmojiDrawable emojiDrawable = new EmojiDrawable();
                emojiDrawable.setBounds(0, 0, fontSize, fontSize);
                spannable.setSpan((Object)new EmojiSpan(emojiDrawable, (View)emojiAsyncLoadTextView), m.start(), m.end(), 17);
                emojiAsyncLoadTextView.addAsyncLoadTask(emojiDrawable, filePath + emojiHex + ".png");
            }
        }
        return spannable;
    }

    public static Spannable filterFromResource(Context context, Spannable spannable, int fontSize) {
        return spannable == null ? null : EmojiDisplay.filterFromResource(context, spannable, fontSize, HEAD_NAME, null);
    }

    public static Spannable filterFromResource(Context context, Spannable spannable, int fontSize, String headName, EmojiDisplayListener emojiDisplayListener) {
        if (spannable == null) {
            return null;
        }
        Matcher m = EmojiDisplay.getMatcher(spannable.toString());
        if (m != null) {
            while (m.find()) {
                String emojiHex = Integer.toHexString(Character.codePointAt(m.group(), 0));
                if (emojiDisplayListener == null) {
                    int itemWidth;
                    int itemHeight;
                    Drawable drawable = EmojiDisplay.getDrawable(context, headName + emojiHex);
                    if (drawable == null) continue;
                    if (fontSize == -1) {
                        itemHeight = drawable.getIntrinsicHeight();
                        itemWidth = drawable.getIntrinsicWidth();
                    } else {
                        itemHeight = fontSize;
                        itemWidth = fontSize;
                    }
                    drawable.setBounds(0, 0, itemHeight, itemWidth);
                    EmojiSpan imageSpan = new EmojiSpan(drawable);
                    spannable.setSpan((Object)imageSpan, m.start(), m.end(), 17);
                    continue;
                }
                emojiDisplayListener.onEmojiDisplay(context, spannable, headName + emojiHex, fontSize, m.start(), m.end());
            }
        }
        return spannable;
    }

    public static Spannable filterAsyncFromResource(Context context, Spannable spannable, int fontSize, String headName, EmojiAsyncLoadTextView emojiAsyncLoadTextView) {
        if (spannable == null) {
            return null;
        }
        Matcher m = EmojiDisplay.getMatcher(spannable.toString());
        if (m != null) {
            while (m.find()) {
                String emojiHex = Integer.toHexString(Character.codePointAt(m.group(), 0));
                int resID = context.getResources().getIdentifier(headName + emojiHex, "mipmap", context.getPackageName());
                if (resID <= 0) {
                    resID = context.getResources().getIdentifier(headName + emojiHex, "drawable", context.getPackageName());
                }
                if (resID <= 0) continue;
                EmojiDrawable emojiDrawable = new EmojiDrawable();
                emojiDrawable.setBounds(0, 0, fontSize, fontSize);
                EmojiSpan emojiSpan = new EmojiSpan(emojiDrawable, (View)emojiAsyncLoadTextView);
                spannable.setSpan((Object)emojiSpan, m.start(), m.end(), 17);
                emojiAsyncLoadTextView.addAsyncLoadTask(emojiDrawable, context.getResources(), resID, null);
            }
        }
        return spannable;
    }

    protected static Drawable getDrawable(Context context, String emojiName) {
        int resID = context.getResources().getIdentifier(emojiName, "mipmap", context.getPackageName());
        if (resID <= 0) {
            resID = context.getResources().getIdentifier(emojiName, "drawable", context.getPackageName());
        }
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                return context.getResources().getDrawable(resID, null);
            }
            return context.getResources().getDrawable(resID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getFontHeight(TextView textView) {
        Paint paint = new Paint();
        paint.setTextSize(textView.getTextSize());
        Paint.FontMetrics fm = paint.getFontMetrics();
        return (int)Math.ceil(fm.bottom - fm.top);
    }
}

