/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractByteCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractLongCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.LongArrays;
import com.carrotsearch.hppcrt.LongByteAssociativeContainer;
import com.carrotsearch.hppcrt.LongByteMap;
import com.carrotsearch.hppcrt.LongContainer;
import com.carrotsearch.hppcrt.LongLookupContainer;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.ByteCursor;
import com.carrotsearch.hppcrt.cursors.LongByteCursor;
import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.BytePredicate;
import com.carrotsearch.hppcrt.predicates.LongBytePredicate;
import com.carrotsearch.hppcrt.predicates.LongPredicate;
import com.carrotsearch.hppcrt.procedures.ByteProcedure;
import com.carrotsearch.hppcrt.procedures.LongByteProcedure;
import com.carrotsearch.hppcrt.procedures.LongProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongByteHashMap
implements LongByteMap,
Cloneable {
    protected byte defaultValue = 0;
    public long[] keys;
    public byte[] values;
    public boolean allocatedDefaultKey = false;
    public byte allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<LongByteCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = LongByteHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public LongByteHashMap() {
        this(8);
    }

    public LongByteHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public LongByteHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public LongByteHashMap(LongByteAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public byte put(long key, byte value) {
        long existing;
        if (key == 0L) {
            if (this.allocatedDefaultKey) {
                byte previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        long[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key == existing) {
                byte oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(LongByteAssociativeContainer container) {
        return this.putAll((Iterable<? extends LongByteCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends LongByteCursor> iterable) {
        int count = this.size();
        for (LongByteCursor longByteCursor : iterable) {
            this.put(longByteCursor.key, longByteCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(long key, byte value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(long key, byte putValue, byte incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (byte)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public byte addTo(long key, byte incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(long pendingKey, byte pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0L);
        long[] oldKeys = this.keys;
        byte[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        long key = 0L;
        byte value = 0;
        int slot = -1;
        long[] keys = this.keys;
        byte[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0L) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            long[] keys = new long[capacity];
            byte[] values = new byte[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public byte remove(long key) {
        long existing;
        if (key == 0L) {
            if (this.allocatedDefaultKey) {
                byte previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        long[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key == existing) {
                byte value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        long[] keys = this.keys;
        byte[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            long existing = keys[slot];
            byte existingValue = values[slot];
            if (existing == 0L) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        --this.assigned;
    }

    @Override
    public int removeAll(LongContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof LongLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0L)) {
                this.allocatedDefaultKey = false;
            }
            long[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                long existing = keys[i];
                if (existing != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (LongCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0L)) {
            this.allocatedDefaultKey = false;
        }
        long[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            long existing = keys[i];
            if (existing != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(LongBytePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0L, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        long[] keys = this.keys;
        byte[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            long existing = keys[i];
            if (existing != 0L && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public byte get(long key) {
        long existing;
        if (key == 0L) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        long[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(long key) {
        long existing;
        if (key == 0L) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        long[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        LongArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = 0;
        if (this.allocatedDefaultKey) {
            h += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        long[] keys = this.keys;
        byte[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            long existing = keys[i];
            if (existing == 0L) continue;
            h += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LongByteHashMap other = (LongByteHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                LongByteCursor c = (LongByteCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                byte otherValue = other.get(c.key);
                if (c.value == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends LongByteProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0L, this.allocatedDefaultKeyValue);
        }
        long[] keys = this.keys;
        byte[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long existing = keys[i];
            if (existing == 0L) continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends LongBytePredicate> T forEach(T predicate) {
        long existing;
        if (this.allocatedDefaultKey && !predicate.apply(0L, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        long[] keys = this.keys;
        byte[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0L || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public LongByteHashMap clone() {
        LongByteHashMap cloned = new LongByteHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongByteCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static LongByteHashMap from(long[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongByteHashMap map = new LongByteHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static LongByteHashMap from(LongByteAssociativeContainer container) {
        return new LongByteHashMap(container);
    }

    public static LongByteHashMap newInstance() {
        return new LongByteHashMap();
    }

    public static LongByteHashMap newInstance(int initialCapacity, double loadFactor) {
        return new LongByteHashMap(initialCapacity, loadFactor);
    }

    @Override
    public byte getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(byte defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        public final ByteCursor cursor = new ByteCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            if (this.cursor.index == LongByteHashMap.this.values.length + 1) {
                if (LongByteHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = LongByteHashMap.this.values.length;
                    this.cursor.value = LongByteHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = LongByteHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && LongByteHashMap.this.keys[i] == 0L; --i) {
            }
            if (i == -1) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = LongByteHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractByteCollection {
        private final LongByteHashMap owner;
        protected final IteratorPool<ByteCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = LongByteHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = LongByteHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(byte value) {
            if (this.owner.allocatedDefaultKey && value == this.owner.allocatedDefaultKeyValue) {
                return true;
            }
            long[] keys = this.owner.keys;
            byte[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0L || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            long[] keys = this.owner.keys;
            byte[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0L) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            long[] keys = this.owner.keys;
            byte[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (keys[slot] == 0L || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(byte e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && e == this.owner.allocatedDefaultKeyValue) {
                this.owner.allocatedDefaultKey = false;
            }
            long[] keys = this.owner.keys;
            byte[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0L && e == values[slot]) {
                    LongByteHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            long[] keys = this.owner.keys;
            byte[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0L && predicate.apply(values[slot])) {
                    LongByteHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public byte[] toArray(byte[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            long[] keys = this.owner.keys;
            byte[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (keys[i] == 0L) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<LongCursor> {
        public final LongCursor cursor = new LongCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            if (this.cursor.index == LongByteHashMap.this.keys.length + 1) {
                if (LongByteHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = LongByteHashMap.this.keys.length;
                    this.cursor.value = 0L;
                    return this.cursor;
                }
                this.cursor.index = LongByteHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && LongByteHashMap.this.keys[i] == 0L; --i) {
            }
            if (i == -1) {
                return (LongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = LongByteHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongByteHashMap owner;
        protected final IteratorPool<LongCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = LongByteHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = LongByteHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(long e) {
            return LongByteHashMap.this.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0L);
            }
            long[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                long existing = keys[i];
                if (existing == 0L) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            long existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0L)) {
                return predicate;
            }
            long[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0L || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(long e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public long[] toArray(long[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0L;
            }
            long[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                long existing = keys[i];
                if (existing == 0L) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<LongByteCursor> {
        public final LongByteCursor cursor = new LongByteCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected LongByteCursor fetch() {
            int i;
            if (this.cursor.index == LongByteHashMap.this.keys.length + 1) {
                if (LongByteHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = LongByteHashMap.this.keys.length;
                    this.cursor.key = 0L;
                    this.cursor.value = LongByteHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = LongByteHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && LongByteHashMap.this.keys[i] == 0L; --i) {
            }
            if (i == -1) {
                return (LongByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = LongByteHashMap.this.keys[i];
            this.cursor.value = LongByteHashMap.this.values[i];
            return this.cursor;
        }
    }
}

