/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractByteCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.ByteArrays;
import com.carrotsearch.hppcrt.ByteContainer;
import com.carrotsearch.hppcrt.ByteLookupContainer;
import com.carrotsearch.hppcrt.ByteObjectAssociativeContainer;
import com.carrotsearch.hppcrt.ByteObjectMap;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.ByteCursor;
import com.carrotsearch.hppcrt.cursors.ByteObjectCursor;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.ByteObjectPredicate;
import com.carrotsearch.hppcrt.predicates.BytePredicate;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.ByteObjectProcedure;
import com.carrotsearch.hppcrt.procedures.ByteProcedure;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteObjectHashMap<VType>
implements ByteObjectMap<VType>,
Cloneable {
    protected VType defaultValue = null;
    public byte[] keys;
    public Object[] values;
    public boolean allocatedDefaultKey = false;
    public VType allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ByteObjectCursor<VType>, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ByteObjectHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
            obj.cursor.value = null;
        }
    });

    public ByteObjectHashMap() {
        this(8);
    }

    public ByteObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ByteObjectHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ByteObjectHashMap(ByteObjectAssociativeContainer<VType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public VType put(byte key, VType value) {
        byte existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                VType previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                Object oldValue = this.values[slot];
                this.values[slot] = value;
                return (VType)oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(ByteObjectAssociativeContainer<? extends VType> container) {
        return this.putAll((Iterable<? extends ByteObjectCursor<? extends VType>>)container);
    }

    @Override
    public int putAll(Iterable<? extends ByteObjectCursor<? extends VType>> iterable) {
        int count = this.size();
        for (ByteObjectCursor<VType> byteObjectCursor : iterable) {
            this.put(byteObjectCursor.key, byteObjectCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(byte key, VType value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    private void expandAndPut(byte pendingKey, VType pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        byte[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        byte key = 0;
        Object value = null;
        int slot = -1;
        byte[] keys = this.keys;
        Object[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            byte[] keys = new byte[capacity];
            Object[] values = new Object[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public VType remove(byte key) {
        byte existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                VType previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = null;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                Object value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        Object[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            byte existing = keys[slot];
            Object existingValue = values[slot];
            if (existing == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        values[gapSlot] = null;
        --this.assigned;
    }

    @Override
    public int removeAll(ByteContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof ByteLookupContainer) {
            if (this.allocatedDefaultKey && other.contains((byte)0)) {
                this.allocatedDefaultKey = false;
                this.allocatedDefaultKeyValue = null;
            }
            byte[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                byte existing = keys[i];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (ByteCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(BytePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((byte)0)) {
            this.allocatedDefaultKey = false;
            this.allocatedDefaultKeyValue = null;
        }
        byte[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            byte existing = keys[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ByteObjectPredicate<? super VType> predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((byte)0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
            this.allocatedDefaultKeyValue = null;
        }
        byte[] keys = this.keys;
        Object[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            byte existing = keys[i];
            if (existing != 0 && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public VType get(byte key) {
        byte existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(byte key) {
        byte existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        this.allocatedDefaultKeyValue = null;
        ByteArrays.blankArray(this.keys, 0, this.keys.length);
        ObjectArrays.blankArray(this.values, 0, this.values.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = 0;
        if (this.allocatedDefaultKey) {
            h += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        byte[] keys = this.keys;
        Object[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            byte existing = keys[i];
            if (existing == 0) continue;
            h += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ByteObjectHashMap other = (ByteObjectHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                ByteObjectCursor c = (ByteObjectCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                VType otherValue = other.get(c.key);
                if (c.value != null ? c.value.equals(otherValue) : otherValue == null) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ByteObjectProcedure<? super VType>> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply((byte)0, this.allocatedDefaultKeyValue);
        }
        byte[] keys = this.keys;
        Object[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte existing = keys[i];
            if (existing == 0) continue;
            procedure.apply(existing, (Object)values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends ByteObjectPredicate<? super VType>> T forEach(T predicate) {
        byte existing;
        if (this.allocatedDefaultKey && !predicate.apply((byte)0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        byte[] keys = this.keys;
        Object[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing, (Object)values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public ByteObjectHashMap<VType> clone() {
        ByteObjectHashMap<VType> cloned = new ByteObjectHashMap<VType>(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ByteObjectCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <VType> ByteObjectHashMap<VType> from(byte[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteObjectHashMap<VType> map = new ByteObjectHashMap<VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <VType> ByteObjectHashMap<VType> from(ByteObjectAssociativeContainer<VType> container) {
        return new ByteObjectHashMap<VType>(container);
    }

    public static <VType> ByteObjectHashMap<VType> newInstance() {
        return new ByteObjectHashMap<VType>();
    }

    public static <VType> ByteObjectHashMap<VType> newInstance(int initialCapacity, double loadFactor) {
        return new ByteObjectHashMap<VType>(initialCapacity, loadFactor);
    }

    @Override
    public VType getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(VType defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        public final ObjectCursor<VType> cursor = new ObjectCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int i;
            if (this.cursor.index == ByteObjectHashMap.this.values.length + 1) {
                if (ByteObjectHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ByteObjectHashMap.this.values.length;
                    this.cursor.value = ByteObjectHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ByteObjectHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ByteObjectHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteObjectHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractObjectCollection<VType> {
        private final ByteObjectHashMap<VType> owner;
        protected final IteratorPool<ObjectCursor<VType>, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = ByteObjectHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = ByteObjectHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                    obj.cursor.value = null;
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(VType value) {
            if (this.owner.allocatedDefaultKey && (value == null ? this.owner.allocatedDefaultKeyValue == null : value.equals(this.owner.allocatedDefaultKeyValue))) {
                return true;
            }
            byte[] keys = this.owner.keys;
            Object[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0 || !(value == null ? values[slot] == null : value.equals(values[slot]))) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            byte[] keys = this.owner.keys;
            Object[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0) continue;
                procedure.apply((Object)values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            byte[] keys = this.owner.keys;
            Object[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (keys[slot] == 0 || predicate.apply((Object)values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(VType e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && (e == null ? this.owner.allocatedDefaultKeyValue == null : e.equals(this.owner.allocatedDefaultKeyValue))) {
                this.owner.allocatedDefaultKey = false;
                this.owner.allocatedDefaultKeyValue = null;
            }
            byte[] keys = this.owner.keys;
            Object[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0 && (e == null ? values[slot] == null : e.equals(values[slot]))) {
                    ByteObjectHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(ObjectPredicate<? super VType> predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
                this.owner.allocatedDefaultKeyValue = null;
            }
            byte[] keys = this.owner.keys;
            Object[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0 && predicate.apply(values[slot])) {
                    ByteObjectHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public VType[] toArray(VType[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            byte[] keys = this.owner.keys;
            Object[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (keys[i] == 0) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<ByteCursor> {
        public final ByteCursor cursor = new ByteCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            if (this.cursor.index == ByteObjectHashMap.this.keys.length + 1) {
                if (ByteObjectHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ByteObjectHashMap.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = ByteObjectHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ByteObjectHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteObjectHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractByteCollection
    implements ByteLookupContainer {
        private final ByteObjectHashMap<VType> owner;
        protected final IteratorPool<ByteCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = ByteObjectHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = ByteObjectHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(byte e) {
            return ByteObjectHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply((byte)0);
            }
            byte[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte existing = keys[i];
                if (existing == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            byte existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply((byte)0)) {
                return predicate;
            }
            byte[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(byte e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public byte[] toArray(byte[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0;
            }
            byte[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                byte existing = keys[i];
                if (existing == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ByteObjectCursor<VType>> {
        public final ByteObjectCursor<VType> cursor = new ByteObjectCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ByteObjectCursor<VType> fetch() {
            int i;
            if (this.cursor.index == ByteObjectHashMap.this.keys.length + 1) {
                if (ByteObjectHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ByteObjectHashMap.this.keys.length;
                    this.cursor.key = 0;
                    this.cursor.value = ByteObjectHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ByteObjectHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ByteObjectHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ByteObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ByteObjectHashMap.this.keys[i];
            this.cursor.value = ByteObjectHashMap.this.values[i];
            return this.cursor;
        }
    }
}

