/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.heaps;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractLongCollection;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.LongContainer;
import com.carrotsearch.hppcrt.LongPriorityQueue;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.LongPredicate;
import com.carrotsearch.hppcrt.procedures.LongProcedure;
import com.carrotsearch.hppcrt.strategies.LongComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongHeapPriorityQueue
extends AbstractLongCollection
implements LongPriorityQueue,
Cloneable {
    public long[] buffer;
    protected int elementsCount;
    protected LongComparator comparator;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<LongCursor, ValueIterator> valueIteratorPool;
    protected long currentOccurenceToBeRemoved;
    protected LongPredicate removeAllOccurencesPredicate = new LongPredicate(){

        public final boolean apply(long value) {
            return value == LongHeapPriorityQueue.this.currentOccurenceToBeRemoved;
        }
    };
    protected long defaultValue;

    public LongHeapPriorityQueue(LongComparator comp, int initialCapacity, ArraySizingStrategy resizer) {
        this.comparator = comp;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = 0;
                obj.size = LongHeapPriorityQueue.this.size();
                ValueIterator.access$102(obj, LongHeapPriorityQueue.this.buffer);
            }

            @Override
            public void reset(ValueIterator obj) {
                ValueIterator.access$102(obj, null);
            }
        });
    }

    public LongHeapPriorityQueue(LongComparator comp) {
        this(comp, 8);
    }

    public LongHeapPriorityQueue() {
        this(null, 8);
    }

    public LongHeapPriorityQueue(int initialCapacity) {
        this(null, initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public LongHeapPriorityQueue(LongComparator comp, int initialCapacity) {
        this(comp, initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public LongHeapPriorityQueue(LongContainer container) {
        this(container.size());
        this.addAll(container);
    }

    public static LongHeapPriorityQueue from(LongContainer container) {
        return new LongHeapPriorityQueue(container);
    }

    public static LongHeapPriorityQueue from(long ... elements) {
        LongHeapPriorityQueue heap = new LongHeapPriorityQueue(elements.length);
        for (long elem : elements) {
            heap.add(elem);
        }
        return heap;
    }

    @Override
    public int removeAll(long e1) {
        this.currentOccurenceToBeRemoved = e1;
        return this.removeAll(this.removeAllOccurencesPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(LongPredicate predicate) {
        int deleted = 0;
        long[] buffer = this.buffer;
        int elementsCount = this.elementsCount;
        int pos = 1;
        try {
            while (pos <= elementsCount) {
                if (predicate.apply(buffer[pos])) {
                    buffer[pos] = buffer[elementsCount];
                    --elementsCount;
                    ++deleted;
                    continue;
                }
                ++pos;
            }
        }
        finally {
            this.elementsCount = elementsCount;
            this.updatePriorities();
        }
        return deleted;
    }

    @Override
    public void clear() {
        this.elementsCount = 0;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    @Override
    public boolean contains(long element) {
        int size = this.elementsCount;
        long[] buff = this.buffer;
        for (int i = 1; i <= size; ++i) {
            if (element != buff[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public <T extends LongProcedure> T forEach(T procedure) {
        long[] buff = this.buffer;
        int size = this.elementsCount;
        for (int i = 1; i <= size; ++i) {
            procedure.apply(buff[i]);
        }
        return procedure;
    }

    @Override
    public <T extends LongPredicate> T forEach(T predicate) {
        long[] buff = this.buffer;
        int size = this.elementsCount;
        for (int i = 1; i <= size && predicate.apply(buff[i]); ++i) {
        }
        return predicate;
    }

    @Override
    public void add(long element) {
        this.ensureBufferSpace(1);
        ++this.elementsCount;
        this.buffer[this.elementsCount] = element;
        this.swim(this.elementsCount);
    }

    @Override
    public long top() {
        long elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
        }
        return elem;
    }

    @Override
    public long popTop() {
        long elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
            if (this.elementsCount == 1) {
                this.elementsCount = 0;
            } else {
                this.buffer[1] = this.buffer[this.elementsCount];
                --this.elementsCount;
                this.sink(1);
            }
        }
        return elem;
    }

    public int addAll(LongContainer container) {
        return this.addAll((Iterable<? extends LongCursor>)container);
    }

    public int addAll(Iterable<? extends LongCursor> iterable) {
        int size = 0;
        long[] buff = this.buffer;
        int count = this.elementsCount;
        for (LongCursor longCursor : iterable) {
            this.ensureBufferSpace(1);
            buff[++count] = longCursor.value;
            ++size;
        }
        this.elementsCount = count;
        this.updatePriorities();
        return size;
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        long[] buff = this.buffer;
        for (int i = 1; i <= max; ++i) {
            h = 31 * h + BitMixer.mix(buff[i]);
        }
        return h;
    }

    @Override
    public void updatePriorities() {
        if (this.comparator == null) {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparable(k);
            }
        } else {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparator(k);
            }
        }
    }

    @Override
    public void updateTopPriority() {
        if (this.elementsCount > 1) {
            this.sink(1);
        }
    }

    public LongHeapPriorityQueue clone() {
        LongHeapPriorityQueue cloned = new LongHeapPriorityQueue(this.comparator, 8, this.resizer);
        cloned.buffer = (long[])this.buffer.clone();
        cloned.defaultValue = this.defaultValue;
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LongHeapPriorityQueue other = (LongHeapPriorityQueue)obj;
            if (other.size() != this.size()) {
                return false;
            }
            if (!(this.comparator == null && other.comparator == null || this.comparator != null && this.comparator.equals(other.comparator))) {
                return false;
            }
            ValueIterator it = this.iterator();
            ValueIterator itOther = other.iterator();
            while (it.hasNext()) {
                long myVal = ((LongCursor)it.next()).value;
                long otherVal = ((LongCursor)itOther.next()).value;
                if (myVal == otherVal) continue;
                it.release();
                itOther.release();
                return false;
            }
            itOther.release();
            return true;
        }
        return false;
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + 1 > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            if (this.buffer == null) {
                ++newSize;
            }
            try {
                long[] newBuffer = new long[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public long[] toArray(long[] target) {
        System.arraycopy(this.buffer, 1, target, 0, this.elementsCount);
        return target;
    }

    public LongComparator comparator() {
        return this.comparator;
    }

    @Override
    public long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(long defaultValue) {
        this.defaultValue = defaultValue;
    }

    private void sinkComparable(int k) {
        int N = this.elementsCount;
        long[] buffer = this.buffer;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && buffer[child] > buffer[child + 1]) {
                ++child;
            }
            if (buffer[k] <= buffer[child]) break;
            long tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            k = child;
        }
    }

    private void sinkComparator(int k) {
        int N = this.elementsCount;
        long[] buffer = this.buffer;
        LongComparator comp = this.comparator;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && comp.compare(buffer[child], buffer[child + 1]) > 0) {
                ++child;
            }
            if (comp.compare(buffer[k], buffer[child]) <= 0) break;
            long tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            k = child;
        }
    }

    private void swimComparable(int k) {
        long[] buffer = this.buffer;
        while (k > 1 && buffer[k >> 1] > buffer[k]) {
            int parent = k >> 1;
            long tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            k = parent;
        }
    }

    private void swimComparator(int k) {
        long[] buffer = this.buffer;
        LongComparator comp = this.comparator;
        while (k > 1 && comp.compare(buffer[k >> 1], buffer[k]) > 0) {
            int parent = k >> 1;
            long tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            k = parent;
        }
    }

    private void swim(int k) {
        if (this.comparator == null) {
            this.swimComparable(k);
        } else {
            this.swimComparator(k);
        }
    }

    private void sink(int k) {
        if (this.comparator == null) {
            this.sinkComparable(k);
        } else {
            this.sinkComparator(k);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<LongCursor> {
        public final LongCursor cursor = new LongCursor();
        private long[] buffer;
        private int size;

        public ValueIterator() {
            this.cursor.index = 0;
            this.size = LongHeapPriorityQueue.this.size();
            this.buffer = LongHeapPriorityQueue.this.buffer;
        }

        @Override
        protected LongCursor fetch() {
            if (this.cursor.index == this.size) {
                return (LongCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ long[] access$102(ValueIterator x0, long[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

