package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.cursors.ObjectByteCursor;

/**
 * An associative container with unique binding from keys to a single value.
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:24+0200",
    value = "KTypeVTypeMap.java") 
public interface ObjectByteMap<KType>
extends ObjectByteAssociativeContainer<KType>
{
    /**
     * Place a given key and value in the container.
     * @return Returns the value previously stored under the given key, if an equal key is already in the map <b>and replaces the existing
     *  value only </b> with the argument value. If the given key was not already in the map,
     *  the given (key, value) pair is inserted in the map and the default value is returned.
     */
    byte put(KType key, byte value);

    /**
     * <a href="http://trove4j.sourceforge.net">Trove</a>-inspired API method. An equivalent
     * of the following code:
     * <pre>
     * if (!map.containsKey(key))
     *      map.put(key, value);
     * </pre>
     * 
     * @param key The key of the value to check.
     * @param value The value to put if <code>key</code> does not exist.
     * @return <code>true</code> if <code>key</code> did not exist and <code>value</code>
     * was placed in the map.
     */
    boolean putIfAbsent(final KType key, final byte value);

     
    /**
     * If <code>key</code> exists, <code>putValue</code> is inserted into the map,
     * otherwise any existing value is incremented by <code>additionValue</code>.
     * 
     * @param key
     *          The key of the value to adjust.
     * @param putValue
     *          The value to put if <code>key</code> does not exist.
     * @param incrementValue
     *          The value to add to the existing value if <code>key</code> exists.
     * @return Returns the current value associated with <code>key</code> (after
     *         changes).
     */
    byte putOrAdd(KType key, byte putValue, byte additionValue);

      

      
    /**
     * An equivalent of calling
     * 
     * <pre>
     * putOrAdd(key, additionValue, additionValue);
     * </pre>
     * 
     * @param key
     *          The key of the value to adjust.
     * @param additionValue
     *          The value to put or add to the existing value if <code>key</code>
     *          exists.
     * @return Returns the current value associated with <code>key</code> (after
     *         changes).
     */
    byte addTo(KType key, byte additionValue);

      

    /**
     * @return Returns the value associated with the given key, or the default value
     * if the key is not associated with any value.
     *
     */
    byte get(KType key);

    /**
     * Puts all keys from another container to this map, replacing the values
     * of existing keys, if such keys are present.
     * 
     * @return Returns the number of keys added to the map as a result of this
     * call (not previously present in the map). Values of existing keys are overwritten.
     */
    int putAll(ObjectByteAssociativeContainer<? extends KType> container);

    /**
     * Puts all keys from an iterable cursor to this map, replacing the values
     * of existing keys, if such keys are present.
     * 
     * @return Returns the number of keys added to the map as a result of this
     * call (not previously present in the map). Values of existing keys are overwritten.
     */
    int putAll(Iterable<? extends ObjectByteCursor<? extends KType>> iterable);

    /**
     * Remove the (key, value) pair associated with the given key, and returns the assocaited value.
     * The default value is returned if the key did not exist in the map.
     * @param key
     */
    byte remove(KType key);

    /**
     * Clear all keys and values in the container.
     */
    void clear();

    /**
     * Returns the "default value" value used in containers methods returning
     * "default value"
     */
    byte getDefaultValue();

    /**
     * Set the "default value" value to be used in containers methods returning
     * "default value"
     */
    void setDefaultValue(final byte defaultValue);
}
