package com.carrotsearch.hppcrt;

import java.util.Arrays;

  
/**
 * Utility class gathering array or CharIndexedContainer handling algorithms for <code>char</code>s.
 * This is a kind of complement for {@link java.util.Arrays}.
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:23+0200",
    value = "KTypeArrays.java") 
public final class CharArrays
{
    /**
     * public  static instance of an empty array of <code>char</code>s.
     */
         public final static char[] EMPTY =  (new char[(0)]);
      

    final private static int BLANK_ARRAY_SIZE_IN_BIT_SHIFT = 10;

    /**
     * Batch blanking array size
     */
    final private static int BLANK_ARRAY_SIZE = 1 << CharArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT;

    /**
     * Batch blanking array with char nulls
     */
         final private static char[] BLANKING_OBJECT_ARRAY = (new char[(CharArrays.BLANK_ARRAY_SIZE)]);
      

    private CharArrays() {

        //nothing
    }

    /**
     * Rotate utility :
     * Transforms the range [[slice_1:  from; mid - 1][slice_2: mid, to - 1]] of table, into
     * [[slice_2][slice_1]]in place, i.e swap the two slices while keeping their own internal order.
     * @param table
     * @param from the start range to consider
     * @param mid start index of the second slice
     * @param to the array end range, exclusive
     */
    public static  void rotate(final char[] table, final int from, final int mid, final int to) {

        CharArrays.reverse(table, from, mid);
        CharArrays.reverse(table, mid, to);
        CharArrays.reverse(table, from, to);
    }

    /**
     * Rotate utility :
     * Transforms the range [[slice_1:  from; mid - 1][slice_2: mid, to - 1]] of CharIndexedContainer, into
     * [[slice_2][slice_1]] in place, i.e swap the two slices while keeping their own internal order.
     * @param table
     * @param from the start range to consider
     * @param mid start index of the second slice
     * @param to the array end range, exclusive
     */
    public static  void rotate(final CharIndexedContainer table, final int from, final int mid, final int to) {

        CharArrays.reverse(table, from, mid);
        CharArrays.reverse(table, mid, to);
        CharArrays.reverse(table, from, to);
    }

    /**
     * Reverse the elements positions of the specified range of array table :
     * @param table
     * @param from the start range to consider
     * @param to the array end range, exclusive
     */
    public static  void reverse(final char[] table, final int from, final int to) {

        final int halfSize = (to - from) >>> 1;
        char tmpValue;

        for (int i = 0; i < halfSize; i++)
        {
            tmpValue = table[i + from];
            table[i + from] = table[to - i - 1];
            table[to - i - 1] = tmpValue;
        }
    }

    /**
     * Reverse the elements positions of the specified range of CharIndexedContainer table :
     * @param table
     * @param from the start range to consider
     * @param to the array end range, exclusive
     */
    public static  void reverse(final CharIndexedContainer table, final int from, final int to) {

        final int halfSize = (to - from) >>> 1;
        char tmpValue;

        for (int i = 0; i < halfSize; i++)
        {
            tmpValue = table.get(i + from);
            table.set(i + from, table.get(to - i - 1));
            table.set(to - i - 1, tmpValue);
        }
    }

    /**
     * Method to blank any char[] array elements to its default value
     * from [startIndex; endIndex[, equivalent to {@link Arrays}.fill(objectArray, startIndex, endIndex, 0 or null)
     */
    public static  void blankArray(final char[] objectArray, final int startIndex, final int endIndex) {

        assert startIndex <= endIndex;

        final int size = endIndex - startIndex;
        final int nbChunks = size >> CharArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT;
        //compute remainder
        final int rem = size & (CharArrays.BLANK_ARRAY_SIZE - 1);

        for (int i = 0; i < nbChunks; i++) {

            System.arraycopy(CharArrays.BLANKING_OBJECT_ARRAY, 0,
                    objectArray, startIndex + (i << CharArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT),
                    CharArrays.BLANK_ARRAY_SIZE);
        } //end for

        //fill the reminder
        if (rem > 0) {
            Arrays.fill(objectArray, startIndex + (nbChunks << CharArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT),
                    startIndex + (nbChunks << CharArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT) + rem, ('\u0000'));
        }
    }

}
