package com.carrotsearch.hppcrt;

import java.util.Arrays;

  
/**
 * Utility class gathering array or ByteIndexedContainer handling algorithms for <code>byte</code>s.
 * This is a kind of complement for {@link java.util.Arrays}.
 */
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:23+0200",
    value = "KTypeArrays.java") 
public final class ByteArrays
{
    /**
     * public  static instance of an empty array of <code>byte</code>s.
     */
         public final static byte[] EMPTY =  (new byte[(0)]);
      

    final private static int BLANK_ARRAY_SIZE_IN_BIT_SHIFT = 10;

    /**
     * Batch blanking array size
     */
    final private static int BLANK_ARRAY_SIZE = 1 << ByteArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT;

    /**
     * Batch blanking array with byte nulls
     */
         final private static byte[] BLANKING_OBJECT_ARRAY = (new byte[(ByteArrays.BLANK_ARRAY_SIZE)]);
      

    private ByteArrays() {

        //nothing
    }

    /**
     * Rotate utility :
     * Transforms the range [[slice_1:  from; mid - 1][slice_2: mid, to - 1]] of table, into
     * [[slice_2][slice_1]]in place, i.e swap the two slices while keeping their own internal order.
     * @param table
     * @param from the start range to consider
     * @param mid start index of the second slice
     * @param to the array end range, exclusive
     */
    public static  void rotate(final byte[] table, final int from, final int mid, final int to) {

        ByteArrays.reverse(table, from, mid);
        ByteArrays.reverse(table, mid, to);
        ByteArrays.reverse(table, from, to);
    }

    /**
     * Rotate utility :
     * Transforms the range [[slice_1:  from; mid - 1][slice_2: mid, to - 1]] of ByteIndexedContainer, into
     * [[slice_2][slice_1]] in place, i.e swap the two slices while keeping their own internal order.
     * @param table
     * @param from the start range to consider
     * @param mid start index of the second slice
     * @param to the array end range, exclusive
     */
    public static  void rotate(final ByteIndexedContainer table, final int from, final int mid, final int to) {

        ByteArrays.reverse(table, from, mid);
        ByteArrays.reverse(table, mid, to);
        ByteArrays.reverse(table, from, to);
    }

    /**
     * Reverse the elements positions of the specified range of array table :
     * @param table
     * @param from the start range to consider
     * @param to the array end range, exclusive
     */
    public static  void reverse(final byte[] table, final int from, final int to) {

        final int halfSize = (to - from) >>> 1;
        byte tmpValue;

        for (int i = 0; i < halfSize; i++)
        {
            tmpValue = table[i + from];
            table[i + from] = table[to - i - 1];
            table[to - i - 1] = tmpValue;
        }
    }

    /**
     * Reverse the elements positions of the specified range of ByteIndexedContainer table :
     * @param table
     * @param from the start range to consider
     * @param to the array end range, exclusive
     */
    public static  void reverse(final ByteIndexedContainer table, final int from, final int to) {

        final int halfSize = (to - from) >>> 1;
        byte tmpValue;

        for (int i = 0; i < halfSize; i++)
        {
            tmpValue = table.get(i + from);
            table.set(i + from, table.get(to - i - 1));
            table.set(to - i - 1, tmpValue);
        }
    }

    /**
     * Method to blank any byte[] array elements to its default value
     * from [startIndex; endIndex[, equivalent to {@link Arrays}.fill(objectArray, startIndex, endIndex, 0 or null)
     */
    public static  void blankArray(final byte[] objectArray, final int startIndex, final int endIndex) {

        assert startIndex <= endIndex;

        final int size = endIndex - startIndex;
        final int nbChunks = size >> ByteArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT;
        //compute remainder
        final int rem = size & (ByteArrays.BLANK_ARRAY_SIZE - 1);

        for (int i = 0; i < nbChunks; i++) {

            System.arraycopy(ByteArrays.BLANKING_OBJECT_ARRAY, 0,
                    objectArray, startIndex + (i << ByteArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT),
                    ByteArrays.BLANK_ARRAY_SIZE);
        } //end for

        //fill the reminder
        if (rem > 0) {
            Arrays.fill(objectArray, startIndex + (nbChunks << ByteArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT),
                    startIndex + (nbChunks << ByteArrays.BLANK_ARRAY_SIZE_IN_BIT_SHIFT) + rem, ((byte)0));
        }
    }

}
