package com.carrotsearch.hppcrt;

import java.util.Arrays;

import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;

  
/**
 * Common superclass for collections.
 */
  
@SuppressWarnings("unchecked")
  
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:21+0200",
    value = "AbstractKTypeCollection.java") 
public abstract class AbstractObjectCollection<KType> implements ObjectCollection<KType>
{
    protected ObjectLookupContainer<? super KType> testContainer;
    protected ObjectPredicate<? super KType> testPredicate;

    protected ObjectPredicate<KType> containsTestPredicate = new ObjectPredicate<KType>() {

        @Override
        public final boolean apply(final KType k)
        {
            return AbstractObjectCollection.this.testContainer.contains(k);
        }
    };

    protected ObjectPredicate<KType> containsNegateTestPredicate = new ObjectPredicate<KType>() {

        @Override
        public final boolean apply(final KType k)
        {
            return !AbstractObjectCollection.this.testContainer.contains(k);
        }
    };

    protected ObjectPredicate<KType> negatePredicate = new ObjectPredicate<KType>() {

        @Override
        public final boolean apply(final KType k)
        {
            return !AbstractObjectCollection.this.testPredicate.apply(k);
        }
    };

    /**
     * Default implementation uses a predicate for removal.
     */
    @Override
    public int removeAll(final ObjectLookupContainer<? super KType> c)
    {
        // We know c holds sub-types of Object and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final ObjectLookupContainer<? super KType> c)
    {
        // We know c holds sub-types of Object and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final ObjectPredicate<? super KType> predicate)
    {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

      
    /**
     * Default implementation for:
     * {@inheritDoc}
     */
    @Override
    @SuppressWarnings("unchecked")
    public <T> T[] toArray(final Class<T> componentClass)
    {
        final int size = size();

        final T[] array = (T[]) java.lang.reflect.Array.newInstance(componentClass, size);

        int i = 0;
        for (final ObjectCursor<KType> c : this)
        {
            array[i++] = (T) c.value;
        }

        return array;
    }

      

    /**
     * Default implementation for:
     * {@inheritDoc}
     */
    @Override
    public KType[] toArray(final KType[] target)
    {
        assert target.length >= size() : "Target array must be >= " + size();

        int i = 0;
        //use default iterator capability
        for (final ObjectCursor<KType> c : this)
        {
            target[i++] = c.value;
        }

        return target;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("boxing")
    @Override
      
    public Object[] toArray()
      
    {
        try {

            return toArray(((KType[])new Object[(size())]));
        } catch (final OutOfMemoryError e) {

            throw new BufferAllocationException(
                    "Not enough memory to allocate a '%s'.toArray() of  %d elements",
                    e,
                    this.getClass().toString(),
                    size());
        }
    }

    /**
     * Convert the contents of this container to a human-friendly string.
     */
    @Override
    public String toString()
    {
        return Arrays.toString(this.toArray());
    }

    @Override
    public boolean isEmpty()
    {
        return size() == 0;
    }
}
