package com.carrotsearch.hppcrt;

import java.util.Arrays;

import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.predicates.LongPredicate;

  
/**
 * Common superclass for collections.
 */
  
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:21+0200",
    value = "AbstractKTypeCollection.java") 
public abstract class AbstractLongCollection implements LongCollection
{
    protected LongLookupContainer testContainer;
    protected LongPredicate testPredicate;

    protected LongPredicate containsTestPredicate = new LongPredicate() {

        @Override
        public final boolean apply(final long k)
        {
            return AbstractLongCollection.this.testContainer.contains(k);
        }
    };

    protected LongPredicate containsNegateTestPredicate = new LongPredicate() {

        @Override
        public final boolean apply(final long k)
        {
            return !AbstractLongCollection.this.testContainer.contains(k);
        }
    };

    protected LongPredicate negatePredicate = new LongPredicate() {

        @Override
        public final boolean apply(final long k)
        {
            return !AbstractLongCollection.this.testPredicate.apply(k);
        }
    };

    /**
     * Default implementation uses a predicate for removal.
     */
    @Override
    public int removeAll(final LongLookupContainer c)
    {
        // We know c holds sub-types of long and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final LongLookupContainer c)
    {
        // We know c holds sub-types of long and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final LongPredicate predicate)
    {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

      

    /**
     * Default implementation for:
     * {@inheritDoc}
     */
    @Override
    public long[] toArray(final long[] target)
    {
        assert target.length >= size() : "Target array must be >= " + size();

        int i = 0;
        //use default iterator capability
        for (final LongCursor c : this)
        {
            target[i++] = c.value;
        }

        return target;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("boxing")
    @Override
         public long [] toArray()
     
    {
        try {

            return toArray((new long[(size())]));
        } catch (final OutOfMemoryError e) {

            throw new BufferAllocationException(
                    "Not enough memory to allocate a '%s'.toArray() of  %d elements",
                    e,
                    this.getClass().toString(),
                    size());
        }
    }

    /**
     * Convert the contents of this container to a human-friendly string.
     */
    @Override
    public String toString()
    {
        return Arrays.toString(this.toArray());
    }

    @Override
    public boolean isEmpty()
    {
        return size() == 0;
    }
}
