package com.carrotsearch.hppcrt;

import java.util.Arrays;

import com.carrotsearch.hppcrt.cursors.DoubleCursor;
import com.carrotsearch.hppcrt.predicates.DoublePredicate;

  
/**
 * Common superclass for collections.
 */
  
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:22+0200",
    value = "AbstractKTypeCollection.java") 
public abstract class AbstractDoubleCollection implements DoubleCollection
{
    protected DoubleLookupContainer testContainer;
    protected DoublePredicate testPredicate;

    protected DoublePredicate containsTestPredicate = new DoublePredicate() {

        @Override
        public final boolean apply(final double k)
        {
            return AbstractDoubleCollection.this.testContainer.contains(k);
        }
    };

    protected DoublePredicate containsNegateTestPredicate = new DoublePredicate() {

        @Override
        public final boolean apply(final double k)
        {
            return !AbstractDoubleCollection.this.testContainer.contains(k);
        }
    };

    protected DoublePredicate negatePredicate = new DoublePredicate() {

        @Override
        public final boolean apply(final double k)
        {
            return !AbstractDoubleCollection.this.testPredicate.apply(k);
        }
    };

    /**
     * Default implementation uses a predicate for removal.
     */
    @Override
    public int removeAll(final DoubleLookupContainer c)
    {
        // We know c holds sub-types of double and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final DoubleLookupContainer c)
    {
        // We know c holds sub-types of double and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final DoublePredicate predicate)
    {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

      

    /**
     * Default implementation for:
     * {@inheritDoc}
     */
    @Override
    public double[] toArray(final double[] target)
    {
        assert target.length >= size() : "Target array must be >= " + size();

        int i = 0;
        //use default iterator capability
        for (final DoubleCursor c : this)
        {
            target[i++] = c.value;
        }

        return target;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("boxing")
    @Override
         public double [] toArray()
     
    {
        try {

            return toArray((new double[(size())]));
        } catch (final OutOfMemoryError e) {

            throw new BufferAllocationException(
                    "Not enough memory to allocate a '%s'.toArray() of  %d elements",
                    e,
                    this.getClass().toString(),
                    size());
        }
    }

    /**
     * Convert the contents of this container to a human-friendly string.
     */
    @Override
    public String toString()
    {
        return Arrays.toString(this.toArray());
    }

    @Override
    public boolean isEmpty()
    {
        return size() == 0;
    }
}
