package com.carrotsearch.hppcrt;

import java.util.Arrays;

import com.carrotsearch.hppcrt.cursors.ByteCursor;
import com.carrotsearch.hppcrt.predicates.BytePredicate;

  
/**
 * Common superclass for collections.
 */
  
 @javax.annotation.Generated(
    date = "2017-07-11T19:16:21+0200",
    value = "AbstractKTypeCollection.java") 
public abstract class AbstractByteCollection implements ByteCollection
{
    protected ByteLookupContainer testContainer;
    protected BytePredicate testPredicate;

    protected BytePredicate containsTestPredicate = new BytePredicate() {

        @Override
        public final boolean apply(final byte k)
        {
            return AbstractByteCollection.this.testContainer.contains(k);
        }
    };

    protected BytePredicate containsNegateTestPredicate = new BytePredicate() {

        @Override
        public final boolean apply(final byte k)
        {
            return !AbstractByteCollection.this.testContainer.contains(k);
        }
    };

    protected BytePredicate negatePredicate = new BytePredicate() {

        @Override
        public final boolean apply(final byte k)
        {
            return !AbstractByteCollection.this.testPredicate.apply(k);
        }
    };

    /**
     * Default implementation uses a predicate for removal.
     */
    @Override
    public int removeAll(final ByteLookupContainer c)
    {
        // We know c holds sub-types of byte and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final ByteLookupContainer c)
    {
        // We know c holds sub-types of byte and we're not modifying c, so go unchecked.
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int retainAll(final BytePredicate predicate)
    {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

      

    /**
     * Default implementation for:
     * {@inheritDoc}
     */
    @Override
    public byte[] toArray(final byte[] target)
    {
        assert target.length >= size() : "Target array must be >= " + size();

        int i = 0;
        //use default iterator capability
        for (final ByteCursor c : this)
        {
            target[i++] = c.value;
        }

        return target;
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("boxing")
    @Override
         public byte [] toArray()
     
    {
        try {

            return toArray((new byte[(size())]));
        } catch (final OutOfMemoryError e) {

            throw new BufferAllocationException(
                    "Not enough memory to allocate a '%s'.toArray() of  %d elements",
                    e,
                    this.getClass().toString(),
                    size());
        }
    }

    /**
     * Convert the contents of this container to a human-friendly string.
     */
    @Override
    public String toString()
    {
        return Arrays.toString(this.toArray());
    }

    @Override
    public boolean isEmpty()
    {
        return size() == 0;
    }
}
