/*
 * Decompiled with CFR 0.152.
 */
package com.volcaniccoder.bottomify;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupMenu;
import android.widget.TextView;
import com.volcaniccoder.bottomify.BottomifyParams;
import com.volcaniccoder.bottomify.OnNavigationItemChangeListener;
import com.volcaniccoder.bottomify.R;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001.B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u0003J\u0006\u0010\u001b\u001a\u00020\u0019J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J \u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0002J\b\u0010#\u001a\u00020\u0019H\u0002J \u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002J\u0018\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u0012H\u0002J\u000e\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0007J\u000e\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\nR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/volcaniccoder/bottomify/BottomifyNavigationView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "itemChangeListener", "Lcom/volcaniccoder/bottomify/OnNavigationItemChangeListener;", "location", "", "navigationItems", "Ljava/util/ArrayList;", "Lcom/volcaniccoder/bottomify/BottomifyNavigationView$NavigationItem;", "Lkotlin/collections/ArrayList;", "needsToScale", "", "outRect", "Landroid/graphics/Rect;", "params", "Lcom/volcaniccoder/bottomify/BottomifyParams;", "selectedPosition", "addListener", "", "navigationItem", "clearSelection", "colorAnim", "activeToPassive", "isTouchingOutsideOfItem", "view", "Landroid/view/View;", "x", "y", "prepareView", "scaleNavigationItem", "startScale", "", "endScale", "selectItem", "withClickSound", "setActiveNavigationIndex", "index", "setOnNavigationItemChangedListener", "listener", "NavigationItem", "bottomify_release"})
public final class BottomifyNavigationView
extends LinearLayout {
    private final BottomifyParams params;
    private final ArrayList<NavigationItem> navigationItems;
    private int selectedPosition;
    private final Rect outRect;
    private final int[] location;
    private boolean needsToScale;
    private OnNavigationItemChangeListener itemChangeListener;

    public final void setOnNavigationItemChangedListener(@NotNull OnNavigationItemChangeListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.itemChangeListener = listener;
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareView() {
        if (this.params.getMenu() == null) {
            throw (Throwable)new NoSuchFieldException("Bottomify: You need to declare app:menu in xml");
        }
        Menu menu = this.params.getMenu();
        if (menu == null) {
            Intrinsics.throwNpe();
        }
        Menu menu2 = menu;
        int n = 0;
        int n2 = menu2.size();
        while (n < n2) {
            int navigationItemColor;
            void index;
            MenuItem navigationItem = menu2.getItem((int)index);
            View navigationItemView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.item_bottomify, (ViewGroup)this, false);
            ImageView imageView = (ImageView)navigationItemView.findViewById(R.id.navigation_item_image);
            TextView textView = (TextView)navigationItemView.findViewById(R.id.navigation_item_text);
            MenuItem menuItem = navigationItem;
            Intrinsics.checkExpressionValueIsNotNull((Object)menuItem, (String)"navigationItem");
            imageView.setImageDrawable(menuItem.getIcon());
            TextView textView2 = textView;
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"textView");
            textView2.setText(navigationItem.getTitle());
            if (navigationItem.isChecked()) {
                navigationItemColor = this.params.getActiveColor();
                this.selectedPosition = index;
            } else {
                navigationItemColor = this.params.getPassiveColor();
            }
            textView.setTextColor(navigationItemColor);
            imageView.setColorFilter(navigationItemColor);
            textView.setTextSize(0, this.params.getItemTextSize());
            int padding = (int)this.params.getItemPadding();
            navigationItemView.setPadding(padding, padding, padding, padding);
            View view = navigationItemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"navigationItemView");
            ImageView imageView2 = imageView;
            Intrinsics.checkExpressionValueIsNotNull((Object)imageView2, (String)"imageView");
            NavigationItem item = new NavigationItem((int)index, view, textView, imageView2);
            this.navigationItems.add(item);
            this.addListener(item);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -2);
            params.weight = 1.0f;
            params.gravity = 17;
            this.addView(navigationItemView, (ViewGroup.LayoutParams)params);
            ++index;
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private final void addListener(NavigationItem navigationItem) {
        navigationItem.getView().setOnTouchListener(new View.OnTouchListener(this, navigationItem){
            final /* synthetic */ BottomifyNavigationView this$0;
            final /* synthetic */ NavigationItem $navigationItem;

            public final boolean onTouch(View $noName_0, MotionEvent event) {
                View view = this.$navigationItem.getView();
                MotionEvent motionEvent = event;
                Intrinsics.checkExpressionValueIsNotNull((Object)motionEvent, (String)"event");
                if (BottomifyNavigationView.access$isTouchingOutsideOfItem(this.this$0, view, (int)motionEvent.getRawX(), (int)event.getRawY()) && BottomifyNavigationView.access$getNeedsToScale$p(this.this$0)) {
                    BottomifyNavigationView.access$scaleNavigationItem(this.this$0, this.$navigationItem, BottomifyNavigationView.access$getParams$p(this.this$0).getEndScale(), BottomifyNavigationView.access$getParams$p(this.this$0).getStartScale());
                    BottomifyNavigationView.access$colorAnim(this.this$0, this.$navigationItem, false);
                    BottomifyNavigationView.access$setNeedsToScale$p(this.this$0, false);
                    Log.w((String)"POS", (String)"OUT");
                }
                if (event.getAction() == 0) {
                    if (BottomifyNavigationView.access$getNeedsToScale$p(this.this$0)) {
                        BottomifyNavigationView.access$scaleNavigationItem(this.this$0, this.$navigationItem, BottomifyNavigationView.access$getParams$p(this.this$0).getStartScale(), BottomifyNavigationView.access$getParams$p(this.this$0).getEndScale());
                        BottomifyNavigationView.access$colorAnim(this.this$0, this.$navigationItem, true);
                        Log.w((String)"POS", (String)"DOWN");
                    }
                    BottomifyNavigationView.access$setNeedsToScale$p(this.this$0, true);
                } else if (event.getAction() == 1) {
                    if (BottomifyNavigationView.access$getNeedsToScale$p(this.this$0)) {
                        BottomifyNavigationView.access$scaleNavigationItem(this.this$0, this.$navigationItem, BottomifyNavigationView.access$getParams$p(this.this$0).getEndScale(), BottomifyNavigationView.access$getParams$p(this.this$0).getStartScale());
                        BottomifyNavigationView.access$selectItem(this.this$0, this.$navigationItem, true);
                        BottomifyNavigationView.access$colorAnim(this.this$0, this.$navigationItem, false);
                        Log.w((String)"POS", (String)"UP");
                    }
                    BottomifyNavigationView.access$setNeedsToScale$p(this.this$0, true);
                }
                return true;
            }
            {
                this.this$0 = bottomifyNavigationView;
                this.$navigationItem = navigationItem;
            }
        });
    }

    private final void selectItem(NavigationItem navigationItem, boolean withClickSound) {
        block1: {
            NavigationItem selectedNavigationItem = this.navigationItems.get(this.selectedPosition);
            selectedNavigationItem.getTextView().setTextColor(this.params.getPassiveColor());
            selectedNavigationItem.getImageView().setColorFilter(this.params.getPassiveColor());
            if (withClickSound) {
                navigationItem.getView().playSoundEffect(0);
            }
            this.selectedPosition = navigationItem.getPosition();
            navigationItem.getTextView().setTextColor(this.params.getActiveColor());
            navigationItem.getImageView().setColorFilter(this.params.getActiveColor());
            OnNavigationItemChangeListener onNavigationItemChangeListener = this.itemChangeListener;
            if (onNavigationItemChangeListener == null) break block1;
            onNavigationItemChangeListener.onNavigationItemChanged(navigationItem);
        }
    }

    public final void setActiveNavigationIndex(int index) {
        NavigationItem navigationItem = this.navigationItems.get(index);
        Intrinsics.checkExpressionValueIsNotNull((Object)navigationItem, (String)"navigationItems[index]");
        this.selectItem(navigationItem, false);
    }

    private final boolean isTouchingOutsideOfItem(View view, int x, int y) {
        view.getDrawingRect(this.outRect);
        view.getLocationOnScreen(this.location);
        this.outRect.offset(this.location[0], this.location[1]);
        return !this.outRect.contains(x, y);
    }

    private final void scaleNavigationItem(NavigationItem navigationItem, float startScale, float endScale) {
        ScaleAnimation animation = new ScaleAnimation(startScale, endScale, startScale, endScale, 1, 0.5f, 2, 0.5f);
        animation.setFillAfter(true);
        animation.setDuration((long)this.params.getAnimationDuration());
        navigationItem.getView().startAnimation((Animation)animation);
    }

    private final void colorAnim(NavigationItem navigationItem, boolean activeToPassive) {
        ValueAnimator colorAnimation;
        int colorTo;
        int colorActive = Intrinsics.areEqual((Object)navigationItem.getView(), (Object)this.navigationItems.get(this.selectedPosition).getView()) ? this.params.getActiveColor() : this.params.getPassiveColor();
        int colorPassive = this.params.getPressedColor();
        int colorFrom = activeToPassive ? colorActive : colorPassive;
        int n = colorTo = activeToPassive ? colorPassive : colorActive;
        if (Intrinsics.areEqual((Object)navigationItem.getView(), (Object)this.navigationItems.get(this.selectedPosition).getView()) && !activeToPassive) {
            colorTo = this.params.getActiveColor();
        }
        ValueAnimator valueAnimator = colorAnimation = ValueAnimator.ofObject((TypeEvaluator)((TypeEvaluator)new ArgbEvaluator()), (Object[])new Object[]{colorFrom, colorTo});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"colorAnimation");
        valueAnimator.setDuration((long)this.params.getAnimationDuration());
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(navigationItem){
            final /* synthetic */ NavigationItem $navigationItem;

            public final void onAnimationUpdate(ValueAnimator animator) {
                ValueAnimator valueAnimator = animator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                int navigationItemColor = (Integer)object;
                this.$navigationItem.getTextView().setTextColor(navigationItemColor);
                this.$navigationItem.getImageView().setColorFilter(navigationItemColor);
            }
            {
                this.$navigationItem = navigationItem;
            }
        });
        colorAnimation.start();
    }

    public final void clearSelection() {
        NavigationItem selectedNavigationItem = this.navigationItems.get(this.selectedPosition);
        selectedNavigationItem.getTextView().setTextColor(this.params.getPassiveColor());
        selectedNavigationItem.getImageView().setColorFilter(this.params.getPassiveColor());
    }

    @JvmOverloads
    public BottomifyNavigationView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.params = new BottomifyParams();
        BottomifyNavigationView bottomifyNavigationView = this;
        ArrayList arrayList = new ArrayList();
        bottomifyNavigationView.navigationItems = arrayList;
        this.outRect = new Rect();
        this.location = new int[2];
        this.needsToScale = true;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BottomifyNavigationView);
        if (a.hasValue(R.styleable.BottomifyNavigationView_menu)) {
            PopupMenu popupMenu = new PopupMenu(context, null);
            Menu menu = popupMenu.getMenu();
            new MenuInflater(context).inflate(a.getResourceId(R.styleable.BottomifyNavigationView_menu, 0), menu);
            this.params.setMenu(menu);
        }
        if (a.hasValue(R.styleable.BottomifyNavigationView_active_color)) {
            int activeColor = a.getColor(R.styleable.BottomifyNavigationView_active_color, 0);
            this.params.setActiveColor(activeColor);
        }
        if (a.hasValue(R.styleable.BottomifyNavigationView_passive_color)) {
            int passiveColor = a.getColor(R.styleable.BottomifyNavigationView_passive_color, 0);
            this.params.setPassiveColor(passiveColor);
        }
        if (a.hasValue(R.styleable.BottomifyNavigationView_pressed_color)) {
            int pressedColor = a.getColor(R.styleable.BottomifyNavigationView_pressed_color, 0);
            this.params.setPressedColor(pressedColor);
        }
        if (a.hasValue(R.styleable.BottomifyNavigationView_item_padding)) {
            float px = a.getDimension(R.styleable.BottomifyNavigationView_item_padding, 0.0f);
            this.params.setItemPadding(px);
        }
        if (a.hasValue(R.styleable.BottomifyNavigationView_item_text_size)) {
            int px = a.getDimensionPixelSize(R.styleable.BottomifyNavigationView_item_text_size, 0);
            this.params.setItemTextSize(px);
        }
        if (a.hasValue(R.styleable.BottomifyNavigationView_animation_duration)) {
            int animDuration = a.getInteger(R.styleable.BottomifyNavigationView_animation_duration, 0);
            this.params.setAnimationDuration(animDuration);
        }
        if (a.hasValue(R.styleable.BottomifyNavigationView_scale_percent)) {
            int scalePercent = a.getInteger(R.styleable.BottomifyNavigationView_scale_percent, 0);
            this.params.setEndScale(1.0f - (float)scalePercent / (float)100);
        }
        a.recycle();
        this.prepareView();
    }

    @JvmOverloads
    public /* synthetic */ BottomifyNavigationView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BottomifyNavigationView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BottomifyNavigationView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ boolean access$isTouchingOutsideOfItem(BottomifyNavigationView $this, @NotNull View view, int x, int y) {
        return $this.isTouchingOutsideOfItem(view, x, y);
    }

    public static final /* synthetic */ boolean access$getNeedsToScale$p(BottomifyNavigationView $this) {
        return $this.needsToScale;
    }

    public static final /* synthetic */ void access$setNeedsToScale$p(BottomifyNavigationView $this, boolean bl) {
        $this.needsToScale = bl;
    }

    public static final /* synthetic */ void access$scaleNavigationItem(BottomifyNavigationView $this, @NotNull NavigationItem navigationItem, float startScale, float endScale) {
        $this.scaleNavigationItem(navigationItem, startScale, endScale);
    }

    @NotNull
    public static final /* synthetic */ BottomifyParams access$getParams$p(BottomifyNavigationView $this) {
        return $this.params;
    }

    public static final /* synthetic */ void access$colorAnim(BottomifyNavigationView $this, @NotNull NavigationItem navigationItem, boolean activeToPassive) {
        $this.colorAnim(navigationItem, activeToPassive);
    }

    public static final /* synthetic */ void access$selectItem(BottomifyNavigationView $this, @NotNull NavigationItem navigationItem, boolean withClickSound) {
        $this.selectItem(navigationItem, withClickSound);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/volcaniccoder/bottomify/BottomifyNavigationView$NavigationItem;", "", "position", "", "view", "Landroid/view/View;", "textView", "Landroid/widget/TextView;", "imageView", "Landroid/widget/ImageView;", "(ILandroid/view/View;Landroid/widget/TextView;Landroid/widget/ImageView;)V", "getImageView", "()Landroid/widget/ImageView;", "getPosition", "()I", "getTextView", "()Landroid/widget/TextView;", "getView", "()Landroid/view/View;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "bottomify_release"})
    public static final class NavigationItem {
        private final int position;
        @NotNull
        private final View view;
        @NotNull
        private final TextView textView;
        @NotNull
        private final ImageView imageView;

        public final int getPosition() {
            return this.position;
        }

        @NotNull
        public final View getView() {
            return this.view;
        }

        @NotNull
        public final TextView getTextView() {
            return this.textView;
        }

        @NotNull
        public final ImageView getImageView() {
            return this.imageView;
        }

        public NavigationItem(int position, @NotNull View view, @NotNull TextView textView, @NotNull ImageView imageView) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
            this.position = position;
            this.view = view;
            this.textView = textView;
            this.imageView = imageView;
        }

        public final int component1() {
            return this.position;
        }

        @NotNull
        public final View component2() {
            return this.view;
        }

        @NotNull
        public final TextView component3() {
            return this.textView;
        }

        @NotNull
        public final ImageView component4() {
            return this.imageView;
        }

        @NotNull
        public final NavigationItem copy(int position, @NotNull View view, @NotNull TextView textView, @NotNull ImageView imageView) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
            return new NavigationItem(position, view, textView, imageView);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NavigationItem copy$default(NavigationItem navigationItem, int n, View view, TextView textView, ImageView imageView, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = navigationItem.position;
            }
            if ((n2 & 2) != 0) {
                view = navigationItem.view;
            }
            if ((n2 & 4) != 0) {
                textView = navigationItem.textView;
            }
            if ((n2 & 8) != 0) {
                imageView = navigationItem.imageView;
            }
            return navigationItem.copy(n, view, textView, imageView);
        }

        public String toString() {
            return "NavigationItem(position=" + this.position + ", view=" + this.view + ", textView=" + this.textView + ", imageView=" + this.imageView + ")";
        }

        public int hashCode() {
            View view = this.view;
            TextView textView = this.textView;
            ImageView imageView = this.imageView;
            return ((this.position * 31 + (view != null ? view.hashCode() : 0)) * 31 + (textView != null ? textView.hashCode() : 0)) * 31 + (imageView != null ? imageView.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NavigationItem)) break block3;
                    NavigationItem navigationItem = (NavigationItem)object;
                    if (!(this.position == navigationItem.position) || !Intrinsics.areEqual((Object)this.view, (Object)navigationItem.view) || !Intrinsics.areEqual((Object)this.textView, (Object)navigationItem.textView) || !Intrinsics.areEqual((Object)this.imageView, (Object)navigationItem.imageView)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

