/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxCellPath;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class mxParallelEdgeLayout
extends mxGraphLayout {
    protected int spacing;

    public mxParallelEdgeLayout(mxGraph graph) {
        this(graph, 20);
    }

    public mxParallelEdgeLayout(mxGraph graph, int spacing) {
        super(graph);
        this.spacing = spacing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Object parent) {
        Map<String, List<Object>> lookup = this.findParallels(parent);
        this.graph.getModel().beginUpdate();
        try {
            for (List<Object> parallels : lookup.values()) {
                if (parallels.size() <= 1) continue;
                this.layout(parallels);
            }
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }

    protected Map<String, List<Object>> findParallels(Object parent) {
        Hashtable<String, List<Object>> lookup = new Hashtable<String, List<Object>>();
        mxIGraphModel model = this.graph.getModel();
        int childCount = model.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            String id;
            Object child = model.getChildAt(parent, i);
            if (this.isEdgeIgnored(child) || (id = this.getEdgeId(child)) == null) continue;
            if (!lookup.containsKey(id)) {
                lookup.put(id, new ArrayList());
            }
            ((List)lookup.get(id)).add(child);
        }
        return lookup;
    }

    protected String getEdgeId(Object edge) {
        Object trg;
        mxGraphView view = this.graph.getView();
        mxCellState state = view.getState(edge);
        Object src = state != null ? state.getVisibleTerminal(true) : view.getVisibleTerminal(edge, true);
        Object object = trg = state != null ? state.getVisibleTerminal(false) : view.getVisibleTerminal(edge, false);
        if (src instanceof mxICell && trg instanceof mxICell) {
            String trgId;
            String srcId = mxCellPath.create((mxICell)src);
            return srcId.compareTo(trgId = mxCellPath.create((mxICell)trg)) > 0 ? trgId + "-" + srcId : srcId + "-" + trgId;
        }
        return null;
    }

    protected void layout(List<Object> parallels) {
        block3: {
            mxGeometry trg;
            mxGeometry src;
            block2: {
                Object edge = parallels.get(0);
                mxIGraphModel model = this.graph.getModel();
                src = model.getGeometry(model.getTerminal(edge, true));
                if (src != (trg = model.getGeometry(model.getTerminal(edge, false)))) break block2;
                double x0 = src.getX() + src.getWidth() + (double)this.spacing;
                double y0 = src.getY() + src.getHeight() / 2.0;
                for (int i = 0; i < parallels.size(); ++i) {
                    this.route(parallels.get(i), x0, y0);
                    x0 += (double)this.spacing;
                }
                break block3;
            }
            if (src == null || trg == null) break block3;
            double scx = src.getX() + src.getWidth() / 2.0;
            double scy = src.getY() + src.getHeight() / 2.0;
            double tcx = trg.getX() + trg.getWidth() / 2.0;
            double tcy = trg.getY() + trg.getHeight() / 2.0;
            double dx = tcx - scx;
            double dy = tcy - scy;
            double len = Math.sqrt(dx * dx + dy * dy);
            double x0 = scx + dx / 2.0;
            double y0 = scy + dy / 2.0;
            double nx = dy * (double)this.spacing / len;
            double ny = dx * (double)this.spacing / len;
            x0 += nx * (double)(parallels.size() - 1) / 2.0;
            y0 -= ny * (double)(parallels.size() - 1) / 2.0;
            for (int i = 0; i < parallels.size(); ++i) {
                this.route(parallels.get(i), x0, y0);
                x0 -= nx;
                y0 += ny;
            }
        }
    }

    protected void route(Object edge, double x, double y) {
        if (this.graph.isCellMovable(edge)) {
            this.setEdgePoints(edge, Arrays.asList(new mxPoint(x, y)));
        }
    }
}

