/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class mxRectangle
extends mxPoint {
    private static final long serialVersionUID = -3793966043543578946L;
    protected double width;
    protected double height;

    public mxRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public mxRectangle(Rectangle2D rect) {
        this(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public mxRectangle(mxRectangle rect) {
        this(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public mxRectangle(double x, double y, double width, double height) {
        super(x, y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double value) {
        this.width = value;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double value) {
        this.height = value;
    }

    public void setRect(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public void add(mxRectangle rect) {
        if (rect != null) {
            double minX = Math.min(this.x, rect.x);
            double minY = Math.min(this.y, rect.y);
            double maxX = Math.max(this.x + this.width, rect.x + rect.width);
            double maxY = Math.max(this.y + this.height, rect.y + rect.height);
            this.x = minX;
            this.y = minY;
            this.width = maxX - minX;
            this.height = maxY - minY;
        }
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public void grow(double amount) {
        this.x -= amount;
        this.y -= amount;
        this.width += 2.0 * amount;
        this.height += 2.0 * amount;
    }

    public boolean contains(double x, double y) {
        return this.x <= x && this.x + this.width >= x && this.y <= y && this.y + this.height >= y;
    }

    public mxPoint intersectLine(double x0, double y0, double x1, double y1) {
        mxPoint result = null;
        result = mxUtils.intersection(this.x, this.y, this.x + this.width, this.y, x0, y0, x1, y1);
        if (result == null) {
            result = mxUtils.intersection(this.x + this.width, this.y, this.x + this.width, this.y + this.height, x0, y0, x1, y1);
        }
        if (result == null) {
            result = mxUtils.intersection(this.x + this.width, this.y + this.height, this.x, this.y + this.height, x0, y0, x1, y1);
        }
        if (result == null) {
            result = mxUtils.intersection(this.x, this.y, this.x, this.y + this.height, x0, y0, x1, y1);
        }
        return result;
    }

    public Rectangle getRectangle() {
        int ix = (int)Math.round(this.x);
        int iy = (int)Math.round(this.y);
        int iw = (int)Math.round(this.width - (double)ix + this.x);
        int ih = (int)Math.round(this.height - (double)iy + this.y);
        return new Rectangle(ix, iy, iw, ih);
    }

    public void rotate90() {
        double t = (this.width - this.height) / 2.0;
        this.x += t;
        this.y -= t;
        double tmp = this.width;
        this.width = this.height;
        this.height = tmp;
    }

    public boolean equals(Object obj) {
        if (obj instanceof mxRectangle) {
            mxRectangle rect = (mxRectangle)obj;
            return rect.getX() == this.getX() && rect.getY() == this.getY() && rect.getWidth() == this.getWidth() && rect.getHeight() == this.getHeight();
        }
        return false;
    }

    public Object clone() {
        mxRectangle clone = (mxRectangle)super.clone();
        clone.setWidth(this.getWidth());
        clone.setHeight(this.getHeight());
        return clone;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(32);
        builder.append(this.getClass().getSimpleName());
        builder.append(" [");
        builder.append("x=");
        builder.append(this.x);
        builder.append(", y=");
        builder.append(this.y);
        builder.append(", width=");
        builder.append(this.width);
        builder.append(", height=");
        builder.append(this.height);
        builder.append("]");
        return builder.toString();
    }
}

