/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.jcache;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.jcache.JCacheEntryProcessor;
import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;
import java.io.Serializable;
import javax.cache.processor.MutableEntry;

public class InitStateProcessor<K extends Serializable>
implements JCacheEntryProcessor<K, Nothing> {
    private static final long serialVersionUID = 1L;
    private BucketConfiguration configuration;
    public static final SerializationHandle<InitStateProcessor<?>> SERIALIZATION_HANDLE = new SerializationHandle<InitStateProcessor<?>>(){

        public <S> InitStateProcessor<?> deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            BucketConfiguration configuration = (BucketConfiguration)adapter.readObject(input, BucketConfiguration.class);
            return new InitStateProcessor(configuration);
        }

        public <O> void serialize(SerializationAdapter<O> adapter, O output, InitStateProcessor<?> processor) throws IOException {
            adapter.writeObject(output, (Object)((InitStateProcessor)processor).configuration);
        }

        public int getTypeId() {
            return 18;
        }

        public Class<InitStateProcessor<?>> getSerializedType() {
            return InitStateProcessor.class;
        }
    };

    public InitStateProcessor(BucketConfiguration configuration) {
        this.configuration = configuration;
    }

    public CommandResult<Nothing> process(MutableEntry<K, GridBucketState> mutableEntry, Object ... arguments) {
        if (mutableEntry.exists()) {
            return CommandResult.success(null);
        }
        long currentTimeNanos = this.currentTimeNanos();
        BucketState bucketState = BucketState.createInitialState((BucketConfiguration)this.configuration, (long)currentTimeNanos);
        GridBucketState gridBucketState = new GridBucketState(this.configuration, bucketState);
        mutableEntry.setValue((Object)gridBucketState);
        return CommandResult.success(null);
    }

    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }
}

