/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.jcache;

import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.grid.jcache.JCacheEntryProcessor;
import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;
import java.io.Serializable;
import javax.cache.processor.MutableEntry;

public class ExecuteProcessor<K extends Serializable, T extends Serializable>
implements JCacheEntryProcessor<K, T> {
    private static final long serialVersionUID = 1L;
    private GridCommand<T> targetCommand;
    public static SerializationHandle<ExecuteProcessor<?, ?>> SERIALIZATION_HANDLE = new SerializationHandle<ExecuteProcessor<?, ?>>(){

        public <S> ExecuteProcessor<?, ?> deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            GridCommand targetCommand = (GridCommand)adapter.readObject(input);
            return new ExecuteProcessor(targetCommand);
        }

        public <O> void serialize(SerializationAdapter<O> adapter, O output, ExecuteProcessor<?, ?> processor) throws IOException {
            adapter.writeObject(output, (Object)((ExecuteProcessor)processor).targetCommand);
        }

        public int getTypeId() {
            return 17;
        }

        public Class<ExecuteProcessor<?, ?>> getSerializedType() {
            return ExecuteProcessor.class;
        }
    };

    public ExecuteProcessor(GridCommand<T> targetCommand) {
        this.targetCommand = targetCommand;
    }

    public CommandResult<T> process(MutableEntry<K, GridBucketState> mutableEntry, Object ... arguments) {
        if (!mutableEntry.exists()) {
            return CommandResult.bucketNotFound();
        }
        long currentTimeNanos = this.currentTimeNanos();
        GridBucketState gridBucketState = (GridBucketState)mutableEntry.getValue();
        Serializable result = this.targetCommand.execute(gridBucketState, currentTimeNanos);
        if (this.targetCommand.isBucketStateModified()) {
            mutableEntry.setValue((Object)gridBucketState);
        }
        return CommandResult.success((Serializable)result);
    }

    public GridCommand<T> getTargetCommand() {
        return this.targetCommand;
    }
}

