/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Request<T>
implements ComparableByContent<Request<T>> {
    private final Version backwardCompatibilityVersion;
    private final RemoteCommand<T> command;
    private final Long clientSideTime;
    public static SerializationHandle<Request> SERIALIZATION_HANDLE = new SerializationHandle<Request>(){

        @Override
        public <S> Request<?> deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int backwardCompatibilityNumber = adapter.readInt(input);
            Versions.check(backwardCompatibilityNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            backwardCompatibilityVersion = Versions.byNumber(backwardCompatibilityNumber);
            RemoteCommand<?> command = RemoteCommand.deserialize(adapter, input, backwardCompatibilityVersion);
            backwardCompatibilityVersion = Versions.byNumber(backwardCompatibilityNumber);
            Long clientTime = null;
            boolean clientTimeProvided = adapter.readBoolean(input);
            if (clientTimeProvided) {
                clientTime = adapter.readLong(input);
            }
            return new Request(command, backwardCompatibilityVersion, clientTime);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, Request request, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeInt(output, backwardCompatibilityVersion.getNumber());
            RemoteCommand.serialize(adapter, output, request.command, backwardCompatibilityVersion);
            if (request.clientSideTime != null) {
                adapter.writeBoolean(output, true);
                adapter.writeLong(output, request.clientSideTime);
            } else {
                adapter.writeBoolean(output, false);
            }
        }

        @Override
        public int getTypeId() {
            return 37;
        }

        @Override
        public Class<Request> getSerializedType() {
            return Request.class;
        }

        @Override
        public Request<?> fromJsonCompatibleSnapshot(Map<String, Object> snapshot, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int backwardCompatibilityNumber = this.readIntValue(snapshot, "backwardCompatibilityNumber");
            Versions.check(backwardCompatibilityNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            backwardCompatibilityVersion = Versions.byNumber(backwardCompatibilityNumber);
            RemoteCommand<?> command = RemoteCommand.fromJsonCompatibleSnapshot((Map)snapshot.get("command"), backwardCompatibilityVersion);
            Long clientTime = null;
            if (snapshot.containsKey("clientTime")) {
                clientTime = this.readLongValue(snapshot, "clientTime");
            }
            return new Request(command, backwardCompatibilityVersion, clientTime);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(Request request, Version backwardCompatibilityVersion) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("backwardCompatibilityNumber", request.backwardCompatibilityVersion.getNumber());
            result.put("command", RemoteCommand.toJsonCompatibleSnapshot(request.command, backwardCompatibilityVersion));
            if (request.clientSideTime != null) {
                result.put("clientTime", request.clientSideTime);
            }
            return result;
        }

        @Override
        public String getTypeName() {
            return "Request";
        }
    };

    public Request(RemoteCommand<T> command, Version backwardCompatibilityVersion, Long clientSideTime) {
        this.command = command;
        this.backwardCompatibilityVersion = backwardCompatibilityVersion;
        this.clientSideTime = clientSideTime;
    }

    public RemoteCommand<T> getCommand() {
        return this.command;
    }

    public Version getBackwardCompatibilityVersion() {
        return this.backwardCompatibilityVersion;
    }

    public Long getClientSideTime() {
        return this.clientSideTime;
    }

    @Override
    public boolean equalsByContent(Request<T> other) {
        return this.backwardCompatibilityVersion.equals(other.backwardCompatibilityVersion) && ComparableByContent.equals(this.command, other.command) && Objects.equals(this.clientSideTime, other.clientSideTime);
    }
}

