/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandError;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.UsageOfObsoleteApiException;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;

public class UsageOfObsoleteApiError
implements ComparableByContent<UsageOfObsoleteApiError>,
CommandError {
    private final int requestedFormatNumber;
    private final int minSupportedFormatNumber;
    public static SerializationHandle<UsageOfObsoleteApiError> SERIALIZATION_HANDLE = new SerializationHandle<UsageOfObsoleteApiError>(){

        @Override
        public <S> UsageOfObsoleteApiError deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int requestedFormatNumber = adapter.readInt(input);
            int minSupportedFormatNumber = adapter.readInt(input);
            return new UsageOfObsoleteApiError(requestedFormatNumber, minSupportedFormatNumber);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, UsageOfObsoleteApiError error, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeInt(output, error.requestedFormatNumber);
            adapter.writeInt(output, error.minSupportedFormatNumber);
        }

        @Override
        public int getTypeId() {
            return 17;
        }

        @Override
        public Class<UsageOfObsoleteApiError> getSerializedType() {
            return UsageOfObsoleteApiError.class;
        }
    };

    public UsageOfObsoleteApiError(int requestedFormatNumber, int minSupportedFormatNumber) {
        this.requestedFormatNumber = requestedFormatNumber;
        this.minSupportedFormatNumber = minSupportedFormatNumber;
    }

    public int getRequestedFormatNumber() {
        return this.requestedFormatNumber;
    }

    public int getMinSupportedFormatNumber() {
        return this.minSupportedFormatNumber;
    }

    @Override
    public RuntimeException asException() {
        return new UsageOfObsoleteApiException(this.requestedFormatNumber, this.minSupportedFormatNumber);
    }

    @Override
    public boolean equalsByContent(UsageOfObsoleteApiError other) {
        return other.requestedFormatNumber == this.requestedFormatNumber && other.minSupportedFormatNumber == this.minSupportedFormatNumber;
    }
}

