/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandError;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.UnsupportedTypeException;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;

public class UnsupportedTypeError
implements CommandError,
ComparableByContent<UnsupportedTypeError> {
    private final int typeId;
    public static SerializationHandle<UnsupportedTypeError> SERIALIZATION_HANDLE = new SerializationHandle<UnsupportedTypeError>(){

        @Override
        public <S> UnsupportedTypeError deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int typeId = adapter.readInt(input);
            return new UnsupportedTypeError(typeId);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, UnsupportedTypeError error, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeInt(output, error.typeId);
        }

        @Override
        public int getTypeId() {
            return 16;
        }

        @Override
        public Class<UnsupportedTypeError> getSerializedType() {
            return UnsupportedTypeError.class;
        }
    };

    public UnsupportedTypeError(int typeId) {
        this.typeId = typeId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    @Override
    public RuntimeException asException() {
        return new UnsupportedTypeException(this.typeId);
    }

    @Override
    public boolean equalsByContent(UnsupportedTypeError other) {
        return other.typeId == this.typeId;
    }
}

