/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.MathType;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.Arrays;

public class BucketStateIEEE754
implements BucketState,
ComparableByContent<BucketStateIEEE754> {
    double[] tokens;
    long[] lastRefillTime;
    BucketConfiguration configuration;
    public static SerializationHandle<BucketStateIEEE754> SERIALIZATION_HANDLE = new SerializationHandle<BucketStateIEEE754>(){

        @Override
        public <S> BucketStateIEEE754 deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            double[] tokens = adapter.readDoubleArray(input);
            long[] lastRefillTime = adapter.readLongArray(input);
            return new BucketStateIEEE754(tokens, lastRefillTime);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, BucketStateIEEE754 state, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeDoubleArray(output, state.tokens);
            adapter.writeLongArray(output, state.lastRefillTime);
        }

        @Override
        public int getTypeId() {
            return 4;
        }

        @Override
        public Class<BucketStateIEEE754> getSerializedType() {
            return BucketStateIEEE754.class;
        }
    };

    BucketStateIEEE754(double[] tokens, long[] lastRefillTime) {
        this.tokens = tokens;
        this.lastRefillTime = lastRefillTime;
    }

    public BucketStateIEEE754(BucketConfiguration configuration, long currentTimeNanos) {
        this.configuration = configuration;
        Bandwidth[] bandwidths = configuration.getBandwidths();
        this.tokens = new double[bandwidths.length];
        this.lastRefillTime = new long[bandwidths.length];
        for (int i = 0; i < bandwidths.length; ++i) {
            this.tokens[i] = this.calculateInitialTokens(bandwidths[i], currentTimeNanos);
            this.lastRefillTime[i] = this.calculateLastRefillTimeNanos(bandwidths[i], currentTimeNanos);
        }
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(BucketConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public BucketState replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy, long currentTimeNanos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceAddTokens(long tokensToAdd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BucketStateIEEE754 copy() {
        BucketStateIEEE754 copy = new BucketStateIEEE754((double[])this.tokens.clone(), (long[])this.lastRefillTime.clone());
        copy.setConfiguration(this.configuration);
        return copy;
    }

    @Override
    public void copyStateFrom(BucketState sourceState) {
        BucketStateIEEE754 sourceStateIEEE754 = (BucketStateIEEE754)sourceState;
        if (sourceStateIEEE754.configuration == this.configuration) {
            System.arraycopy(sourceStateIEEE754.tokens, 0, this.tokens, 0, this.tokens.length);
            System.arraycopy(sourceStateIEEE754.lastRefillTime, 0, this.lastRefillTime, 0, this.lastRefillTime.length);
        } else {
            this.configuration = sourceStateIEEE754.configuration;
            this.lastRefillTime = (long[])sourceStateIEEE754.lastRefillTime.clone();
            this.tokens = (double[])sourceStateIEEE754.tokens.clone();
        }
    }

    @Override
    public long getCurrentSize(int bandwidth) {
        return (long)this.tokens[bandwidth];
    }

    @Override
    public long getRoundingError(int bandwidth) {
        return 0L;
    }

    @Override
    public MathType getMathType() {
        return MathType.IEEE_754;
    }

    @Override
    public long getAvailableTokens() {
        long availableTokens = (long)this.tokens[0];
        for (int i = 1; i < this.tokens.length; ++i) {
            availableTokens = Math.min(availableTokens, (long)this.tokens[i]);
        }
        return availableTokens;
    }

    @Override
    public void consume(long toConsume) {
        int i = 0;
        while (i < this.tokens.length) {
            int n = i++;
            this.tokens[n] = this.tokens[n] - (double)toConsume;
        }
    }

    @Override
    public void addTokens(long tokensToAdd) {
        Bandwidth[] bandwidths = this.configuration.getBandwidths();
        for (int i = 0; i < bandwidths.length; ++i) {
            double currentSize = this.tokens[i];
            double newSize = currentSize + (double)tokensToAdd;
            this.tokens[i] = newSize >= (double)bandwidths[i].getCapacity() ? (double)bandwidths[i].getCapacity() : newSize;
        }
    }

    @Override
    public void refillAllBandwidth(long currentTimeNanos) {
        Bandwidth[] limits = this.configuration.getBandwidths();
        for (int i = 0; i < limits.length; ++i) {
            this.refill(i, limits[i], currentTimeNanos);
        }
    }

    private void refill(int bandwidthIndex, Bandwidth bandwidth, long currentTimeNanos) {
        double calculatedRefill;
        long previousRefillNanos = this.lastRefillTime[bandwidthIndex];
        if (currentTimeNanos <= previousRefillNanos) {
            return;
        }
        if (bandwidth.isRefillIntervally()) {
            long incompleteIntervalCorrection = (currentTimeNanos - previousRefillNanos) % bandwidth.getRefillPeriodNanos();
            currentTimeNanos -= incompleteIntervalCorrection;
        }
        if (currentTimeNanos <= previousRefillNanos) {
            return;
        }
        this.lastRefillTime[bandwidthIndex] = currentTimeNanos;
        long capacity = bandwidth.getCapacity();
        long refillPeriodNanos = bandwidth.getRefillPeriodNanos();
        long refillTokens = bandwidth.getRefillTokens();
        double newSize = this.tokens[bandwidthIndex];
        long durationSinceLastRefillNanos = currentTimeNanos - previousRefillNanos;
        if (durationSinceLastRefillNanos > refillPeriodNanos) {
            long elapsedPeriods = durationSinceLastRefillNanos / refillPeriodNanos;
            long calculatedRefill2 = elapsedPeriods * refillTokens;
            if ((newSize += (double)calculatedRefill2) > (double)capacity) {
                this.tokens[bandwidthIndex] = capacity;
                return;
            }
            durationSinceLastRefillNanos %= refillPeriodNanos;
        }
        if ((newSize += (calculatedRefill = (double)durationSinceLastRefillNanos / (double)refillPeriodNanos * (double)refillTokens)) >= (double)capacity) {
            newSize = capacity;
        }
        this.tokens[bandwidthIndex] = newSize;
    }

    @Override
    public long calculateDelayNanosAfterWillBePossibleToConsume(long tokensToConsume, long currentTimeNanos, boolean checkTokensToConsumeShouldBeLessThenCapacity) {
        Bandwidth[] bandwidths = this.configuration.getBandwidths();
        long delayAfterWillBePossibleToConsume = this.calculateDelayNanosAfterWillBePossibleToConsumeForBandwidth(0, bandwidths[0], tokensToConsume, currentTimeNanos, checkTokensToConsumeShouldBeLessThenCapacity);
        for (int i = 1; i < bandwidths.length; ++i) {
            Bandwidth bandwidth = bandwidths[i];
            long delay = this.calculateDelayNanosAfterWillBePossibleToConsumeForBandwidth(i, bandwidth, tokensToConsume, currentTimeNanos, checkTokensToConsumeShouldBeLessThenCapacity);
            delayAfterWillBePossibleToConsume = Math.max(delayAfterWillBePossibleToConsume, delay);
        }
        return delayAfterWillBePossibleToConsume;
    }

    @Override
    public long calculateFullRefillingTime(long currentTimeNanos) {
        Bandwidth[] bandwidths = this.configuration.getBandwidths();
        long maxTimeToFullRefillNanos = this.calculateFullRefillingTime(0, bandwidths[0], currentTimeNanos);
        for (int i = 1; i < bandwidths.length; ++i) {
            maxTimeToFullRefillNanos = Math.max(maxTimeToFullRefillNanos, this.calculateFullRefillingTime(i, bandwidths[i], currentTimeNanos));
        }
        return maxTimeToFullRefillNanos;
    }

    private long calculateFullRefillingTime(int bandwidthIndex, Bandwidth bandwidth, long currentTimeNanos) {
        long availableTokens = this.getCurrentSize(bandwidthIndex);
        if (availableTokens >= bandwidth.capacity) {
            return 0L;
        }
        double deficit = bandwidth.capacity - availableTokens;
        double nanosToWait = bandwidth.isRefillIntervally() ? this.calculateDelayNanosAfterWillBePossibleToConsumeForIntervalBandwidth(bandwidthIndex, bandwidth, deficit, currentTimeNanos) : this.calculateDelayNanosAfterWillBePossibleToConsumeForGreedyBandwidth(bandwidth, deficit);
        return nanosToWait < 9.223372036854776E18 ? (long)nanosToWait : Long.MAX_VALUE;
    }

    private long calculateDelayNanosAfterWillBePossibleToConsumeForBandwidth(int bandwidthIndex, Bandwidth bandwidth, long tokensToConsume, long currentTimeNanos, boolean checkTokensToConsumeShouldBeLessThenCapacity) {
        if (checkTokensToConsumeShouldBeLessThenCapacity && tokensToConsume > bandwidth.capacity) {
            return Long.MAX_VALUE;
        }
        double currentSize = this.tokens[bandwidthIndex];
        if ((double)tokensToConsume <= currentSize) {
            return 0L;
        }
        double deficit = (double)tokensToConsume - currentSize;
        double nanosToWait = bandwidth.isRefillIntervally() ? this.calculateDelayNanosAfterWillBePossibleToConsumeForIntervalBandwidth(bandwidthIndex, bandwidth, deficit, currentTimeNanos) : this.calculateDelayNanosAfterWillBePossibleToConsumeForGreedyBandwidth(bandwidth, deficit);
        return nanosToWait < 9.223372036854776E18 ? (long)nanosToWait : Long.MAX_VALUE;
    }

    private double calculateDelayNanosAfterWillBePossibleToConsumeForGreedyBandwidth(Bandwidth bandwidth, double deficit) {
        return (double)bandwidth.getRefillPeriodNanos() * deficit / (double)bandwidth.getRefillTokens();
    }

    private double calculateDelayNanosAfterWillBePossibleToConsumeForIntervalBandwidth(int bandwidthIndex, Bandwidth bandwidth, double deficit, long currentTimeNanos) {
        long refillPeriodNanos = bandwidth.getRefillPeriodNanos();
        long refillTokens = bandwidth.getRefillTokens();
        long previousRefillNanos = this.lastRefillTime[bandwidthIndex];
        long timeOfNextRefillNanos = previousRefillNanos + refillPeriodNanos;
        long waitForNextRefillNanos = timeOfNextRefillNanos - currentTimeNanos;
        if (deficit <= (double)refillTokens) {
            return waitForNextRefillNanos;
        }
        double deficitPeriodsAsDouble = Math.ceil((deficit -= (double)refillTokens) / (double)refillTokens);
        double deficitNanos = deficitPeriodsAsDouble * (double)refillPeriodNanos;
        return deficitNanos + (double)waitForNextRefillNanos;
    }

    private long calculateLastRefillTimeNanos(Bandwidth bandwidth, long currentTimeNanos) {
        if (!bandwidth.isIntervallyAligned()) {
            return currentTimeNanos;
        }
        return bandwidth.timeOfFirstRefillMillis * 1000000L - bandwidth.refillPeriodNanos;
    }

    private long calculateInitialTokens(Bandwidth bandwidth, long currentTimeNanos) {
        if (!bandwidth.useAdaptiveInitialTokens) {
            return bandwidth.initialTokens;
        }
        long timeOfFirstRefillNanos = bandwidth.timeOfFirstRefillMillis * 1000000L;
        if (currentTimeNanos >= timeOfFirstRefillNanos) {
            return bandwidth.initialTokens;
        }
        long guaranteedBase = Math.max(0L, bandwidth.capacity - bandwidth.refillTokens);
        long nanosBeforeFirstRefill = timeOfFirstRefillNanos - currentTimeNanos;
        return Math.min(bandwidth.capacity, guaranteedBase + (long)((double)nanosBeforeFirstRefill * (double)bandwidth.refillTokens / (double)bandwidth.refillPeriodNanos));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BucketState{");
        sb.append("tokens=").append(Arrays.toString(this.tokens));
        sb.append(", lastRefillTime=").append(Arrays.toString(this.lastRefillTime));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equalsByContent(BucketStateIEEE754 other) {
        return Arrays.equals(this.tokens, other.tokens) && Arrays.equals(this.lastRefillTime, other.lastRefillTime);
    }
}

