/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.commands.VerboseCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import java.io.IOException;

public interface RemoteCommand<T> {
    public CommandResult<T> execute(MutableBucketEntry var1, long var2);

    default public VerboseCommand<T> asVerbose() {
        return new VerboseCommand(this);
    }

    default public boolean isInitializationCommand() {
        return false;
    }

    public SerializationHandle<RemoteCommand<?>> getSerializationHandle();

    public boolean isImmediateSyncRequired(long var1, long var3);

    public long estimateTokensToConsume();

    public long getConsumedTokens(T var1);

    public static <O> void serialize(SerializationAdapter<O> adapter, O output, RemoteCommand<?> command, Version backwardCompatibilityVersion) throws IOException {
        SerializationHandle<RemoteCommand<?>> serializer = command.getSerializationHandle();
        adapter.writeInt(output, serializer.getTypeId());
        serializer.serialize(adapter, output, command, backwardCompatibilityVersion);
    }

    public static <I> RemoteCommand<?> deserialize(DeserializationAdapter<I> adapter, I input, Version backwardCompatibilityVersion) throws IOException {
        int typeId = adapter.readInt(input);
        SerializationHandle serializer = SerializationHandle.CORE_HANDLES.getHandleByTypeId(typeId);
        return (RemoteCommand)serializer.deserialize(adapter, input, backwardCompatibilityVersion);
    }
}

