/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.generic.select_for_update;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.generic.GenericEntry;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.LockBasedTransaction;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.LockResult;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.Request;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractLockBasedProxyManager<K>
extends AbstractProxyManager<K> {
    protected AbstractLockBasedProxyManager(ClientSideConfig clientSideConfig) {
        super(AbstractLockBasedProxyManager.injectTimeClock(clientSideConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CommandResult<T> execute(K key, Request<T> request) {
        LockBasedTransaction transaction = this.allocateTransaction(key);
        try {
            CommandResult<T> commandResult = this.execute(request, transaction);
            return commandResult;
        }
        finally {
            this.releaseTransaction(transaction);
        }
    }

    @Override
    public boolean isAsyncModeSupported() {
        return false;
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        throw new UnsupportedOperationException();
    }

    protected abstract LockBasedTransaction allocateTransaction(K var1);

    protected abstract void releaseTransaction(LockBasedTransaction var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> CommandResult<T> execute(Request<T> request, LockBasedTransaction transaction) {
        RemoteCommand<T> command = request.getCommand();
        transaction.begin();
        try {
            try {
                byte[] persistedDataOnBeginOfTransaction;
                LockResult lockResult = transaction.lock();
                if (lockResult == LockResult.DATA_EXISTS_AND_LOCKED) {
                    persistedDataOnBeginOfTransaction = transaction.getData();
                } else {
                    if (!command.isInitializationCommand()) {
                        CommandResult commandResult = CommandResult.bucketNotFound();
                        return commandResult;
                    }
                    persistedDataOnBeginOfTransaction = null;
                }
                GenericEntry entry = new GenericEntry(persistedDataOnBeginOfTransaction, request.getBackwardCompatibilityVersion());
                CommandResult<T> result = command.execute(entry, super.getClientSideTime());
                if (entry.isModified()) {
                    byte[] bytes = entry.getModifiedStateBytes();
                    if (persistedDataOnBeginOfTransaction == null) {
                        transaction.create(bytes);
                    } else {
                        transaction.update(bytes);
                    }
                }
                transaction.commit();
                CommandResult<T> commandResult = result;
                return commandResult;
            }
            finally {
                transaction.unlock();
            }
        }
        catch (RuntimeException e) {
            transaction.rollback();
            throw e;
        }
    }

    private static ClientSideConfig injectTimeClock(ClientSideConfig clientSideConfig) {
        if (clientSideConfig.getClientSideClock().isPresent()) {
            return clientSideConfig;
        }
        return clientSideConfig.withClientClock(TimeMeter.SYSTEM_MILLISECONDS);
    }
}

