/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;
import java.io.Serializable;

public class GridBucketState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BucketConfiguration configuration;
    private BucketState state;
    public static final SerializationHandle<GridBucketState> SERIALIZATION_HANDLE = new SerializationHandle<GridBucketState>(){

        @Override
        public <S> GridBucketState deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            BucketConfiguration bucketConfiguration = adapter.readObject(input, BucketConfiguration.class);
            BucketState bucketState = adapter.readObject(input, BucketState.class);
            return new GridBucketState(bucketConfiguration, bucketState);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, GridBucketState gridState) throws IOException {
            adapter.writeObject(output, gridState.configuration);
            adapter.writeObject(output, gridState.state);
        }

        @Override
        public int getTypeId() {
            return 4;
        }

        @Override
        public Class<GridBucketState> getSerializedType() {
            return GridBucketState.class;
        }
    };

    public GridBucketState(BucketConfiguration configuration, BucketState state) {
        this.configuration = configuration;
        this.state = state;
    }

    public GridBucketState deepCopy() {
        return new GridBucketState(this.configuration, this.state.copy());
    }

    public void refillAllBandwidth(long currentTimeNanos) {
        this.state.refillAllBandwidth(this.configuration.getBandwidths(), currentTimeNanos);
    }

    public long getAvailableTokens() {
        return this.state.getAvailableTokens(this.configuration.getBandwidths());
    }

    public void consume(long tokensToConsume) {
        this.state.consume(this.configuration.getBandwidths(), tokensToConsume);
    }

    public long calculateDelayNanosAfterWillBePossibleToConsume(long tokensToConsume, long currentTimeNanos) {
        return this.state.calculateDelayNanosAfterWillBePossibleToConsume(this.configuration.getBandwidths(), tokensToConsume, currentTimeNanos);
    }

    public void addTokens(long tokensToAdd) {
        this.state.addTokens(this.configuration.getBandwidths(), tokensToAdd);
    }

    public BucketState copyBucketState() {
        return this.state.copy();
    }

    public void replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy, long currentTimeNanos) {
        this.state = this.state.replaceConfiguration(this.configuration, newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
        this.configuration = newConfiguration;
    }

    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    public BucketState getState() {
        return this.state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GridBucketState{");
        sb.append("configuration=").append(this.configuration);
        sb.append(", state=").append(this.state);
        sb.append('}');
        return sb.toString();
    }
}

