/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;
import java.io.Serializable;

public class EstimationProbe
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final boolean canBeConsumed;
    private final long remainingTokens;
    private final long nanosToWaitForRefill;
    public static final SerializationHandle<EstimationProbe> SERIALIZATION_HANDLE = new SerializationHandle<EstimationProbe>(){

        @Override
        public <S> EstimationProbe deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            boolean canBeConsumed = adapter.readBoolean(input);
            long remainingTokens = adapter.readLong(input);
            long nanosToWaitForRefill = adapter.readLong(input);
            return new EstimationProbe(canBeConsumed, remainingTokens, nanosToWaitForRefill);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, EstimationProbe probe) throws IOException {
            adapter.writeBoolean(output, probe.canBeConsumed);
            adapter.writeLong(output, probe.remainingTokens);
            adapter.writeLong(output, probe.nanosToWaitForRefill);
        }

        @Override
        public int getTypeId() {
            return 16;
        }

        @Override
        public Class<EstimationProbe> getSerializedType() {
            return EstimationProbe.class;
        }
    };

    public static EstimationProbe canBeConsumed(long remainingTokens) {
        return new EstimationProbe(true, remainingTokens, 0L);
    }

    public static EstimationProbe canNotBeConsumed(long remainingTokens, long nanosToWaitForRefill) {
        return new EstimationProbe(false, remainingTokens, nanosToWaitForRefill);
    }

    private EstimationProbe(boolean canBeConsumed, long remainingTokens, long nanosToWaitForRefill) {
        this.canBeConsumed = canBeConsumed;
        this.remainingTokens = Math.max(0L, remainingTokens);
        this.nanosToWaitForRefill = nanosToWaitForRefill;
    }

    public boolean canBeConsumed() {
        return this.canBeConsumed;
    }

    public long getRemainingTokens() {
        return this.remainingTokens;
    }

    public long getNanosToWaitForRefill() {
        return this.nanosToWaitForRefill;
    }

    public String toString() {
        return "ConsumptionResult{isConsumed=" + this.canBeConsumed + ", remainingTokens=" + this.remainingTokens + ", nanosToWaitForRefill=" + this.nanosToWaitForRefill + '}';
    }
}

