/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.AbstractBucketBuilder;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.ConfigurationBuilder;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.Extension;
import io.github.bucket4j.grid.AddTokensCommand;
import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.ConsumeAsMuchAsPossibleCommand;
import io.github.bucket4j.grid.ConsumeIgnoringRateLimitsCommand;
import io.github.bucket4j.grid.CreateSnapshotCommand;
import io.github.bucket4j.grid.EstimateAbilityToConsumeCommand;
import io.github.bucket4j.grid.GetAvailableTokensCommand;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.ReplaceConfigurationOrReturnPreviousCommand;
import io.github.bucket4j.grid.ReserveAndCalculateTimeToSleepCommand;
import io.github.bucket4j.grid.TryConsumeAndReturnRemainingTokensCommand;
import io.github.bucket4j.grid.TryConsumeCommand;
import io.github.bucket4j.local.LocalBucketBuilder;
import io.github.bucket4j.serialization.SerializationHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class Bucket4j {
    private static final Map<Class, Extension> extensions = new HashMap<Class, Extension>();
    private static final List<SerializationHandle<?>> serializationHandles;

    public static List<SerializationHandle<?>> getSerializationHandles() {
        return serializationHandles;
    }

    private Bucket4j() {
    }

    public static LocalBucketBuilder builder() {
        return new LocalBucketBuilder();
    }

    public static ConfigurationBuilder configurationBuilder() {
        return new ConfigurationBuilder();
    }

    public static <T extends AbstractBucketBuilder<T>, E extends Extension<T>> E extension(Class<E> extensionClass) {
        Extension extension = extensions.get(extensionClass);
        if (extension == null) {
            String msg = "extension with class [" + extensionClass + "] is not registered";
            throw new IllegalArgumentException(msg);
        }
        return (E)extension;
    }

    static {
        for (Extension extension : ServiceLoader.load(Extension.class)) {
            extensions.put(extension.getClass(), extension);
        }
        serializationHandles = Collections.unmodifiableList(new ArrayList<SerializationHandle<?>>(){
            {
                HashMap<Integer, SerializationHandle> serializersById = new HashMap<Integer, SerializationHandle>();
                List<SerializationHandle> coreHandles = Arrays.asList(Bandwidth.SERIALIZATION_HANDLE, BucketConfiguration.SERIALIZATION_HANDLE, BucketState.SERIALIZATION_HANDLE, GridBucketState.SERIALIZATION_HANDLE, ReserveAndCalculateTimeToSleepCommand.SERIALIZATION_HANDLE, AddTokensCommand.SERIALIZATION_HANDLE, ConsumeAsMuchAsPossibleCommand.SERIALIZATION_HANDLE, CreateSnapshotCommand.SERIALIZATION_HANDLE, GetAvailableTokensCommand.SERIALIZATION_HANDLE, EstimateAbilityToConsumeCommand.SERIALIZATION_HANDLE, TryConsumeCommand.SERIALIZATION_HANDLE, TryConsumeAndReturnRemainingTokensCommand.SERIALIZATION_HANDLE, ReplaceConfigurationOrReturnPreviousCommand.SERIALIZATION_HANDLE, ConsumeIgnoringRateLimitsCommand.SERIALIZATION_HANDLE, CommandResult.SERIALIZATION_HANDLE, ConsumptionProbe.SERIALIZATION_HANDLE, EstimationProbe.SERIALIZATION_HANDLE);
                ArrayList<SerializationHandle> allHandles = new ArrayList<SerializationHandle>(coreHandles);
                for (Extension extension : extensions.values()) {
                    allHandles.addAll(extension.getSerializers());
                }
                for (SerializationHandle coreHandle : allHandles) {
                    int typeId = coreHandle.getTypeId();
                    SerializationHandle conflictingHandle = (SerializationHandle)serializersById.get(typeId);
                    if (conflictingHandle != null) {
                        String msg = "Serialization ID " + typeId + " duplicated for " + coreHandle + " and " + conflictingHandle;
                        throw new IllegalArgumentException(msg);
                    }
                    serializersById.put(typeId, coreHandle);
                }
                this.addAll(allHandles);
            }
        });
    }
}

