/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.Refill;
import java.io.Serializable;
import java.time.Duration;

public class Bandwidth
implements Serializable {
    private static final long serialVersionUID = 101L;
    final long capacity;
    final long initialTokens;
    final long refillPeriodNanos;
    final long refillTokens;
    final boolean refillIntervally;
    final long timeOfFirstRefillMillis;
    final boolean useAdaptiveInitialTokens;

    private Bandwidth(long capacity, long refillPeriodNanos, long refillTokens, long initialTokens, boolean refillIntervally, long timeOfFirstRefillMillis, boolean useAdaptiveInitialTokens) {
        this.capacity = capacity;
        this.initialTokens = initialTokens;
        this.refillPeriodNanos = refillPeriodNanos;
        this.refillTokens = refillTokens;
        this.refillIntervally = refillIntervally;
        this.timeOfFirstRefillMillis = timeOfFirstRefillMillis;
        this.useAdaptiveInitialTokens = useAdaptiveInitialTokens;
    }

    public static Bandwidth simple(long capacity, Duration period) {
        Refill refill = Refill.greedy(capacity, period);
        return Bandwidth.classic(capacity, refill);
    }

    public static Bandwidth classic(long capacity, Refill refill) {
        if (capacity <= 0L) {
            throw BucketExceptions.nonPositiveCapacity(capacity);
        }
        if (refill == null) {
            throw BucketExceptions.nullBandwidthRefill();
        }
        return new Bandwidth(capacity, refill.periodNanos, refill.tokens, capacity, refill.refillIntervally, refill.timeOfFirstRefillMillis, refill.useAdaptiveInitialTokens);
    }

    public Bandwidth withInitialTokens(long initialTokens) {
        if (initialTokens < 0L) {
            throw BucketExceptions.nonPositiveInitialTokens(initialTokens);
        }
        if (this.isIntervallyAligned() && this.useAdaptiveInitialTokens) {
            throw BucketExceptions.intervallyAlignedRefillWithAdaptiveInitialTokensIncompatipleWithManualSpecifiedInitialTokens();
        }
        return new Bandwidth(this.capacity, this.refillPeriodNanos, this.refillTokens, initialTokens, this.refillIntervally, this.timeOfFirstRefillMillis, this.useAdaptiveInitialTokens);
    }

    public boolean isIntervallyAligned() {
        return this.timeOfFirstRefillMillis != Long.MIN_VALUE;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getInitialTokens() {
        return this.initialTokens;
    }

    public long getRefillPeriodNanos() {
        return this.refillPeriodNanos;
    }

    public long getRefillTokens() {
        return this.refillTokens;
    }

    public static long getSerialVersionUID() {
        return 101L;
    }

    public long getTimeOfFirstRefillMillis() {
        return this.timeOfFirstRefillMillis;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Bandwidth{");
        sb.append("capacity=").append(this.capacity);
        sb.append(", initialTokens=").append(this.initialTokens);
        sb.append(", refillPeriodNanos=").append(this.refillPeriodNanos);
        sb.append(", refillTokens=").append(this.refillTokens);
        sb.append(", refillIntervally=").append(this.refillIntervally);
        sb.append(", timeOfFirstRefillMillis=").append(this.timeOfFirstRefillMillis);
        sb.append(", useAdaptiveInitialTokens=").append(this.useAdaptiveInitialTokens);
        sb.append('}');
        return sb.toString();
    }
}

