/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.Refill;
import java.io.Serializable;
import java.time.Duration;

public class Bandwidth
implements Serializable {
    private static final long serialVersionUID = 42L;
    static final long GREEDY_REFILL_INTERVAL = 0L;
    final long capacity;
    final long initialTokens;
    final long refillPeriodNanos;
    final long refillTokens;
    final long refillRefreshIntervalNanos;

    private Bandwidth(long capacity, long refillPeriodNanos, long refillTokens, long initialTokens, long refillRefreshIntervalNanos) {
        this.capacity = capacity;
        this.initialTokens = initialTokens;
        this.refillPeriodNanos = refillPeriodNanos;
        this.refillTokens = refillTokens;
        this.refillRefreshIntervalNanos = refillRefreshIntervalNanos;
    }

    public static Bandwidth simple(long capacity, Duration period) {
        Refill refill = Refill.of(capacity, period);
        return Bandwidth.classic(capacity, refill);
    }

    public static Bandwidth classic(long capacity, Refill refill) {
        if (capacity <= 0L) {
            throw BucketExceptions.nonPositiveCapacity(capacity);
        }
        if (refill == null) {
            throw BucketExceptions.nullBandwidthRefill();
        }
        return new Bandwidth(capacity, refill.periodNanos, refill.tokens, capacity, 0L);
    }

    public Bandwidth withInitialTokens(long initialTokens) {
        if (initialTokens < 0L) {
            throw BucketExceptions.nonPositiveInitialTokens(initialTokens);
        }
        return new Bandwidth(this.capacity, this.refillPeriodNanos, this.refillTokens, initialTokens, this.refillRefreshIntervalNanos);
    }

    public Bandwidth withFixedRefillInterval(Duration fixedRefillInterval) {
        if (fixedRefillInterval == null) {
            throw BucketExceptions.nullFixedRefillInterval();
        }
        if (fixedRefillInterval.isNegative() || fixedRefillInterval.isZero()) {
            throw BucketExceptions.nonPositiveFixedRefillInterval(fixedRefillInterval);
        }
        return new Bandwidth(this.capacity, this.refillPeriodNanos, this.refillTokens, this.initialTokens, fixedRefillInterval.toNanos());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Bandwidth{");
        sb.append("capacity=").append(this.capacity);
        sb.append(", initialTokens=").append(this.initialTokens);
        sb.append(", refillPeriodNanos=").append(this.refillPeriodNanos);
        sb.append(", refillTokens=").append(this.refillTokens);
        sb.append(", refillRefreshIntervalNanos=").append(this.refillRefreshIntervalNanos);
        sb.append('}');
        return sb.toString();
    }
}

