/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BandwidthDefinition;
import io.github.bucket4j.BucketConfiguration;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationBuilder<T extends ConfigurationBuilder> {
    private List<BandwidthDefinition> bandwidths = new ArrayList<BandwidthDefinition>(1);

    protected ConfigurationBuilder() {
    }

    public BucketConfiguration buildConfiguration() {
        return new BucketConfiguration(this.bandwidths);
    }

    public T addLimit(Bandwidth bandwidth) {
        this.bandwidths.add(BandwidthDefinition.unspecifiedInitialTokens(bandwidth));
        return (T)this;
    }

    public T addLimit(long initialTokens, Bandwidth bandwidth) {
        this.bandwidths.add(BandwidthDefinition.withInitialTokens(bandwidth, initialTokens));
        return (T)this;
    }

    public String toString() {
        return "AbstractBucketBuilder{, bandwidths=" + this.bandwidths + '}';
    }
}

