/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.ConfigurationBuilder;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.local.FakeLock;
import io.github.bucket4j.local.LockFreeBucket;
import io.github.bucket4j.local.SynchronizationStrategy;
import io.github.bucket4j.local.SynchronizedBucket;

public class LocalBucketBuilder
extends ConfigurationBuilder<LocalBucketBuilder> {
    private TimeMeter timeMeter = TimeMeter.SYSTEM_MILLISECONDS;

    public LocalBucketBuilder withNanosecondPrecision() {
        this.timeMeter = TimeMeter.SYSTEM_NANOTIME;
        return this;
    }

    public LocalBucketBuilder withMillisecondPrecision() {
        this.timeMeter = TimeMeter.SYSTEM_MILLISECONDS;
        return this;
    }

    public LocalBucketBuilder withCustomTimePrecision(TimeMeter customTimeMeter) {
        if (customTimeMeter == null) {
            throw BucketExceptions.nullTimeMeter();
        }
        this.timeMeter = customTimeMeter;
        return this;
    }

    public Bucket build() {
        return this.build(SynchronizationStrategy.LOCK_FREE);
    }

    public Bucket build(SynchronizationStrategy synchronizationStrategy) {
        BucketConfiguration configuration = this.buildConfiguration();
        switch (synchronizationStrategy) {
            case LOCK_FREE: {
                return new LockFreeBucket(configuration, this.timeMeter);
            }
            case SYNCHRONIZED: {
                return new SynchronizedBucket(configuration, this.timeMeter);
            }
            case NONE: {
                return new SynchronizedBucket(configuration, this.timeMeter, FakeLock.INSTANCE);
            }
        }
        throw new IllegalStateException();
    }
}

