/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BandwidthDefinition;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.IncompatibleConfigurationException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public final class BucketConfiguration
implements Serializable {
    public static final long INITIAL_TOKENS_UNSPECIFIED = -1L;
    private static final long serialVersionUID = 42L;
    private final Bandwidth[] bandwidths;
    private final long[] bandwidthsInitialTokens;

    public BucketConfiguration(List<BandwidthDefinition> bandwidths) {
        if (bandwidths.isEmpty()) {
            throw BucketExceptions.restrictionsNotSpecified();
        }
        this.bandwidths = new Bandwidth[bandwidths.size()];
        this.bandwidthsInitialTokens = new long[bandwidths.size()];
        for (int i = 0; i < bandwidths.size(); ++i) {
            this.bandwidths[i] = bandwidths.get(i).getBandwidth();
            this.bandwidthsInitialTokens[i] = bandwidths.get(i).getInitialTokens();
        }
    }

    public Bandwidth[] getBandwidths() {
        return this.bandwidths;
    }

    public long[] getBandwidthsInitialTokens() {
        return this.bandwidthsInitialTokens;
    }

    public String toString() {
        return "BucketConfiguration{bandwidths=" + Arrays.toString(this.bandwidths) + '}';
    }

    public void checkCompatibility(BucketConfiguration newConfiguration) {
        if (!this.isCompatible(newConfiguration)) {
            throw new IncompatibleConfigurationException(this, newConfiguration);
        }
    }

    public boolean isCompatible(BucketConfiguration newConfiguration) {
        return this.bandwidths.length == newConfiguration.bandwidths.length;
    }
}

