/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.BlockingStrategy;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.grid.AddTokensCommand;
import io.github.bucket4j.grid.BucketNotFoundException;
import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.ConsumeAsMuchAsPossibleCommand;
import io.github.bucket4j.grid.CreateSnapshotCommand;
import io.github.bucket4j.grid.GetAvailableTokensCommand;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.grid.GridProxy;
import io.github.bucket4j.grid.RecoveryStrategy;
import io.github.bucket4j.grid.ReserveAndCalculateTimeToSleepCommand;
import io.github.bucket4j.grid.TryConsumeAndReturnRemainingTokensCommand;
import io.github.bucket4j.grid.TryConsumeCommand;
import java.io.Serializable;
import java.util.function.Supplier;

public class GridBucket<K extends Serializable>
extends AbstractBucket {
    private final K key;
    private final GridProxy<K> gridProxy;
    private final RecoveryStrategy recoveryStrategy;
    private final Supplier<BucketConfiguration> configurationSupplier;

    public static <T extends Serializable> GridBucket<T> createLazyBucket(T key, Supplier<BucketConfiguration> configurationSupplier, GridProxy<T> gridProxy) {
        return new GridBucket<T>(key, configurationSupplier, gridProxy, RecoveryStrategy.RECONSTRUCT, false);
    }

    public static <T extends Serializable> GridBucket<T> createInitializedBucket(T key, BucketConfiguration configuration, GridProxy<T> gridProxy, RecoveryStrategy recoveryStrategy) {
        return new GridBucket<T>(key, () -> configuration, gridProxy, recoveryStrategy, true);
    }

    private GridBucket(K key, Supplier<BucketConfiguration> configurationSupplier, GridProxy<K> gridProxy, RecoveryStrategy recoveryStrategy, boolean initializeBucket) {
        this.key = key;
        this.gridProxy = gridProxy;
        this.recoveryStrategy = recoveryStrategy;
        this.configurationSupplier = configurationSupplier;
        if (initializeBucket) {
            this.initializeBucket();
        }
    }

    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        return this.execute(new ConsumeAsMuchAsPossibleCommand(limit));
    }

    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        return this.execute(new TryConsumeCommand(tokensToConsume));
    }

    @Override
    protected ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long tokensToConsume) {
        return this.execute(new TryConsumeAndReturnRemainingTokensCommand(tokensToConsume));
    }

    @Override
    protected boolean consumeOrAwaitImpl(long tokensToConsume, long waitIfBusyNanosLimit, boolean uninterruptibly, BlockingStrategy blockingStrategy) throws InterruptedException {
        ReserveAndCalculateTimeToSleepCommand consumeCommand = new ReserveAndCalculateTimeToSleepCommand(tokensToConsume, waitIfBusyNanosLimit);
        long nanosToSleep = this.execute(consumeCommand);
        if (nanosToSleep == Long.MAX_VALUE) {
            return false;
        }
        if (nanosToSleep > 0L) {
            if (uninterruptibly) {
                blockingStrategy.parkUninterruptibly(nanosToSleep);
            } else {
                blockingStrategy.park(nanosToSleep);
            }
        }
        return true;
    }

    @Override
    protected void addTokensImpl(long tokensToAdd) {
        this.execute(new AddTokensCommand(tokensToAdd));
    }

    @Override
    public long getAvailableTokens() {
        return this.execute(new GetAvailableTokensCommand());
    }

    @Override
    public BucketState createSnapshot() {
        return this.execute(new CreateSnapshotCommand());
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.configurationSupplier.get();
    }

    private <T extends Serializable> T execute(GridCommand<T> command) {
        CommandResult<T> result = this.gridProxy.execute(this.key, command);
        if (!result.isBucketNotFound()) {
            return result.getData();
        }
        if (this.recoveryStrategy == RecoveryStrategy.THROW_BUCKET_NOT_FOUND_EXCEPTION) {
            throw new BucketNotFoundException((Serializable)this.key);
        }
        this.initializeBucket();
        result = this.gridProxy.execute(this.key, command);
        if (!result.isBucketNotFound()) {
            return result.getData();
        }
        throw new BucketNotFoundException((Serializable)this.key);
    }

    private void initializeBucket() {
        BucketConfiguration configuration = this.getConfiguration();
        GridBucketState initialState = new GridBucketState(configuration, BucketState.createInitialState(configuration));
        this.gridProxy.setInitialState(this.key, initialState);
    }
}

